/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SessionLoadAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;

public class DownloadSessionTask
extends AbstractDownloadTask<Object> {
    private static final String PATTERN_SESSION = "https?://.*/.*\\.jo(s|z)";
    private SessionLoadAction.Loader loader;

    @Override
    public String getTitle() {
        return I18n.tr("Download session", new Object[0]);
    }

    @Override
    public String[] getPatterns() {
        return new String[]{PATTERN_SESSION};
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        if (string != null && string.matches(PATTERN_SESSION)) {
            try {
                URL uRL = new URL(string);
                this.loader = new SessionLoadAction.Loader(HttpClient.create(uRL).connect().getContent(), uRL.toURI(), string.endsWith(".joz"));
                return Main.worker.submit(this.loader);
            }
            catch (IOException | URISyntaxException exception) {
                Main.error(exception);
            }
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.loader != null) {
            this.loader.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL uRL) {
        return null;
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return Main.pref.getBoolean("remotecontrol.import.allow_session", false);
    }
}

