/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Point;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public abstract class AbstractTMSTileSource
extends AbstractTileSource {
    protected String name;
    protected String baseUrl;
    protected String id;
    private final Map<String, String> noTileHeaders;
    private final Map<String, String> metadataHeaders;
    protected int tileSize;
    protected OsmMercator osmMercator;

    public AbstractTMSTileSource(TileSourceInfo tileSourceInfo) {
        this.name = tileSourceInfo.getName();
        this.baseUrl = tileSourceInfo.getUrl();
        if (this.baseUrl != null && this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        this.id = tileSourceInfo.getUrl();
        this.noTileHeaders = tileSourceInfo.getNoTileHeaders();
        this.metadataHeaders = tileSourceInfo.getMetadataHeaders();
        this.tileSize = tileSourceInfo.getTileSize();
        this.osmMercator = new OsmMercator(this.tileSize);
    }

    @Override
    public int getDefaultTileSize() {
        return 256;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMaxZoom() {
        return 21;
    }

    @Override
    public int getMinZoom() {
        return 0;
    }

    public String getExtension() {
        return "png";
    }

    public String getTilePath(int n, int n2, int n3) throws IOException {
        return "/" + n + "/" + n2 + "/" + n3 + "." + this.getExtension();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) throws IOException {
        return this.getBaseUrl() + this.getTilePath(n, n2, n3);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int getTileSize() {
        if (this.tileSize <= 0) {
            return this.getDefaultTileSize();
        }
        return this.tileSize;
    }

    @Override
    public double getDistance(double d, double d2, double d3, double d4) {
        return this.osmMercator.getDistance(d, d2, d3, d4);
    }

    @Override
    public Point latLonToXY(double d, double d2, int n) {
        return new Point((int)this.osmMercator.lonToX(d2, n), (int)this.osmMercator.latToY(d, n));
    }

    @Override
    public Point latLonToXY(ICoordinate iCoordinate, int n) {
        return this.latLonToXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public ICoordinate xyToLatLon(Point point, int n) {
        return this.xyToLatLon(point.x, point.y, n);
    }

    @Override
    public ICoordinate xyToLatLon(int n, int n2, int n3) {
        return new Coordinate(this.osmMercator.yToLat(n2, n3), this.osmMercator.xToLon(n, n3));
    }

    @Override
    public TileXY latLonToTileXY(double d, double d2, int n) {
        return new TileXY(this.osmMercator.lonToX(d2, n) / (double)this.tileSize, this.osmMercator.latToY(d, n) / (double)this.tileSize);
    }

    @Override
    public TileXY latLonToTileXY(ICoordinate iCoordinate, int n) {
        return this.latLonToTileXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public ICoordinate tileXYToLatLon(TileXY tileXY, int n) {
        return this.tileXYToLatLon(tileXY.getXIndex(), tileXY.getYIndex(), n);
    }

    @Override
    public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    @Override
    public ICoordinate tileXYToLatLon(int n, int n2, int n3) {
        return new Coordinate(this.osmMercator.yToLat(n2 * this.tileSize, n3), this.osmMercator.xToLon(n * this.tileSize, n3));
    }

    @Override
    public int getTileXMax(int n) {
        return AbstractTMSTileSource.getTileMax(n);
    }

    @Override
    public int getTileXMin(int n) {
        return 0;
    }

    @Override
    public int getTileYMax(int n) {
        return AbstractTMSTileSource.getTileMax(n);
    }

    @Override
    public int getTileYMin(int n) {
        return 0;
    }

    @Override
    public boolean isNoTileAtZoom(Map<String, List<String>> map, int n, byte[] byArray) {
        if (this.noTileHeaders != null && map != null) {
            for (Map.Entry<String, String> entry : this.noTileHeaders.entrySet()) {
                List<String> list = map.get(entry.getKey());
                if (list == null) continue;
                for (String string : list) {
                    if (!string.matches(entry.getValue())) continue;
                    return true;
                }
            }
        }
        return super.isNoTileAtZoom(map, n, byArray);
    }

    @Override
    public Map<String, String> getMetadata(Map<String, List<String>> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.metadataHeaders != null && map != null) {
            for (Map.Entry<String, String> entry : this.metadataHeaders.entrySet()) {
                List<String> list = map.get(entry.getKey());
                if (list == null) continue;
                for (String string : list) {
                    hashMap.put(entry.getValue(), string);
                }
            }
        }
        return hashMap;
    }

    @Override
    public String getTileId(int n, int n2, int n3) {
        return this.baseUrl + "/" + n + "/" + n2 + "/" + n3;
    }

    private static int getTileMax(int n) {
        return (int)Math.pow(2.0, n) - 1;
    }
}

