/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Resources {
    private static Map<String, Integer> MNEMONIC_LOOKUP = Collections.synchronizedMap(new HashMap());

    private Resources() {
        throw new AssertionError();
    }

    public static String format(String string, Object ... objectArray) {
        return MessageFormat.format(string, objectArray);
    }

    public static int getMnemonicInt(String string) {
        Integer n = MNEMONIC_LOOKUP.get(string);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static void initializeMessages(Class<?> clazz, String string) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        for (Field field : clazz.getFields()) {
            if (!Resources.isWritableField(field)) continue;
            String string2 = field.getName();
            String string3 = Resources.getMessage(resourceBundle, string2);
            int n = Resources.findMnemonicInt(string3);
            string3 = Resources.removeMnemonicAmpersand(string3);
            string3 = Resources.replaceWithPlatformLineFeed(string3);
            Resources.setFieldValue(field, string3);
            MNEMONIC_LOOKUP.put(string3, n);
        }
    }

    private static boolean isWritableField(Field field) {
        int n = field.getModifiers();
        return Modifier.isPublic(n) && Modifier.isStatic(n) && !Modifier.isFinal(n);
    }

    private static String getMessage(ResourceBundle resourceBundle, String string) {
        if (resourceBundle == null) {
            return "missing resource bundle";
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "missing message for key = \"" + string + "\" in resource bundle ";
        }
    }

    private static void setFieldValue(Field field, String string) {
        try {
            field.set(null, string);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new Error("Unable to access or set message for field " + field.getName());
        }
    }

    private static String replaceWithPlatformLineFeed(String string) {
        return string.replace("\n", System.getProperty("line.separator"));
    }

    private static String removeMnemonicAmpersand(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '&' && i != string.length() - 1 && string.charAt(i + 1) != '&') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static int findMnemonicInt(String string) {
        for (int i = 0; i < string.length() - 1; ++i) {
            if (string.charAt(i) != '&') continue;
            if (string.charAt(i + 1) != '&') {
                return Resources.lookupMnemonicInt(string.substring(i + 1, i + 2));
            }
            ++i;
        }
        return 0;
    }

    private static int lookupMnemonicInt(String string) {
        try {
            return KeyEvent.class.getDeclaredField("VK_" + string.toUpperCase()).getInt(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return 0;
        }
    }
}

