/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ktab;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTabConstants;
import sun.security.krb5.internal.ktab.KeyTabEntry;
import sun.security.krb5.internal.ktab.KeyTabInputStream;
import sun.security.krb5.internal.ktab.KeyTabOutputStream;

public class KeyTab
implements KeyTabConstants {
    private static final boolean DEBUG = Krb5.DEBUG;
    private static String defaultTabName = null;
    private static Map<String, KeyTab> map = new HashMap<String, KeyTab>();
    private boolean isMissing = false;
    private boolean isValid = true;
    private final String tabName;
    private long lastModified;
    private int kt_vno = 1282;
    private Vector<KeyTabEntry> entries = new Vector();

    private KeyTab(String string) {
        this.tabName = string;
        try {
            this.lastModified = new File(this.tabName).lastModified();
            try (KeyTabInputStream keyTabInputStream = new KeyTabInputStream(new FileInputStream(string));){
                this.load(keyTabInputStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.entries.clear();
            this.isMissing = true;
        }
        catch (Exception exception) {
            this.entries.clear();
            this.isValid = false;
        }
    }

    private static synchronized KeyTab getInstance0(String string) {
        long l = new File(string).lastModified();
        KeyTab keyTab = map.get(string);
        if (keyTab != null && keyTab.isValid() && keyTab.lastModified == l) {
            return keyTab;
        }
        KeyTab keyTab2 = new KeyTab(string);
        if (keyTab2.isValid()) {
            map.put(string, keyTab2);
            return keyTab2;
        }
        if (keyTab != null) {
            return keyTab;
        }
        return keyTab2;
    }

    public static KeyTab getInstance(String string) {
        if (string == null) {
            return KeyTab.getInstance();
        }
        return KeyTab.getInstance0(KeyTab.normalize(string));
    }

    public static KeyTab getInstance(File file) {
        if (file == null) {
            return KeyTab.getInstance();
        }
        return KeyTab.getInstance0(file.getPath());
    }

    public static KeyTab getInstance() {
        return KeyTab.getInstance(KeyTab.getDefaultTabName());
    }

    public boolean isMissing() {
        return this.isMissing;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private static String getDefaultTabName() {
        String string;
        if (defaultTabName != null) {
            return defaultTabName;
        }
        String string2 = null;
        try {
            string = Config.getInstance().getDefault("default_keytab_name", "libdefaults");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreTokens() && !new File(string2 = KeyTab.normalize(stringTokenizer.nextToken())).exists()) {
                }
            }
        }
        catch (KrbException krbException) {
            string2 = null;
        }
        if (string2 == null) {
            string = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            if (string == null) {
                string = AccessController.doPrivileged(new GetPropertyAction("user.dir"));
            }
            string2 = string + File.separator + "krb5.keytab";
        }
        defaultTabName = string2;
        return string2;
    }

    public static String normalize(String string) {
        String string2 = string.length() >= 5 && string.substring(0, 5).equalsIgnoreCase("FILE:") ? string.substring(5) : (string.length() >= 9 && string.substring(0, 9).equalsIgnoreCase("ANY:FILE:") ? string.substring(9) : (string.length() >= 7 && string.substring(0, 7).equalsIgnoreCase("SRVTAB:") ? string.substring(7) : string));
        return string2;
    }

    private void load(KeyTabInputStream keyTabInputStream) throws IOException, RealmException {
        this.entries.clear();
        this.kt_vno = keyTabInputStream.readVersion();
        if (this.kt_vno == 1281) {
            keyTabInputStream.setNativeByteOrder();
        }
        int n = 0;
        while (keyTabInputStream.available() > 0) {
            n = keyTabInputStream.readEntryLength();
            KeyTabEntry keyTabEntry = keyTabInputStream.readEntry(n, this.kt_vno);
            if (DEBUG) {
                System.out.println(">>> KeyTab: load() entry length: " + n + "; type: " + (keyTabEntry != null ? keyTabEntry.keyType : 0));
            }
            if (keyTabEntry == null) continue;
            this.entries.addElement(keyTabEntry);
        }
    }

    public EncryptionKey[] readServiceKeys(PrincipalName principalName) {
        int n = this.entries.size();
        ArrayList<EncryptionKey> arrayList = new ArrayList<EncryptionKey>(n);
        for (int i = n - 1; i >= 0; --i) {
            KeyTabEntry keyTabEntry = this.entries.elementAt(i);
            if (!keyTabEntry.service.match(principalName)) continue;
            if (EType.isSupported(keyTabEntry.keyType)) {
                EncryptionKey encryptionKey = new EncryptionKey(keyTabEntry.keyblock, keyTabEntry.keyType, new Integer(keyTabEntry.keyVersion));
                arrayList.add(encryptionKey);
                if (!DEBUG) continue;
                System.out.println("Added key: " + keyTabEntry.keyType + "version: " + keyTabEntry.keyVersion);
                continue;
            }
            if (!DEBUG) continue;
            System.out.println("Found unsupported keytype (" + keyTabEntry.keyType + ") for " + principalName);
        }
        n = arrayList.size();
        EncryptionKey[] encryptionKeyArray = arrayList.toArray(new EncryptionKey[n]);
        if (DEBUG) {
            System.out.println("Ordering keys wrt default_tkt_enctypes list");
        }
        final int[] nArray = EType.getDefaults("default_tkt_enctypes");
        Arrays.sort(encryptionKeyArray, new Comparator<EncryptionKey>(){

            @Override
            public int compare(EncryptionKey encryptionKey, EncryptionKey encryptionKey2) {
                int n;
                int n2;
                if (nArray != null && (n2 = encryptionKey.getEType()) != (n = encryptionKey2.getEType())) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] == n2) {
                            return -1;
                        }
                        if (nArray[i] != n) continue;
                        return 1;
                    }
                }
                return encryptionKey2.getKeyVersionNumber() - encryptionKey.getKeyVersionNumber();
            }
        });
        return encryptionKeyArray;
    }

    public boolean findServiceEntry(PrincipalName principalName) {
        for (int i = 0; i < this.entries.size(); ++i) {
            KeyTabEntry keyTabEntry = this.entries.elementAt(i);
            if (!keyTabEntry.service.match(principalName)) continue;
            if (EType.isSupported(keyTabEntry.keyType)) {
                return true;
            }
            if (!DEBUG) continue;
            System.out.println("Found unsupported keytype (" + keyTabEntry.keyType + ") for " + principalName);
        }
        return false;
    }

    public String tabName() {
        return this.tabName;
    }

    public void addEntry(PrincipalName principalName, char[] cArray, int n, boolean bl) throws KrbException {
        int n2;
        EncryptionKey[] encryptionKeyArray = EncryptionKey.acquireSecretKeys(cArray, principalName.getSalt());
        int n3 = 0;
        for (n2 = this.entries.size() - 1; n2 >= 0; --n2) {
            KeyTabEntry keyTabEntry = this.entries.get(n2);
            if (!keyTabEntry.service.match(principalName)) continue;
            if (keyTabEntry.keyVersion > n3) {
                n3 = keyTabEntry.keyVersion;
            }
            if (bl && keyTabEntry.keyVersion != n) continue;
            this.entries.removeElementAt(n2);
        }
        if (n == -1) {
            n = n3 + 1;
        }
        for (n2 = 0; encryptionKeyArray != null && n2 < encryptionKeyArray.length; ++n2) {
            int n4 = encryptionKeyArray[n2].getEType();
            byte[] byArray = encryptionKeyArray[n2].getBytes();
            KeyTabEntry keyTabEntry = new KeyTabEntry(principalName, principalName.getRealm(), new KerberosTime(System.currentTimeMillis()), n, n4, byArray);
            this.entries.addElement(keyTabEntry);
        }
    }

    public KeyTabEntry[] getEntries() {
        KeyTabEntry[] keyTabEntryArray = new KeyTabEntry[this.entries.size()];
        for (int i = 0; i < keyTabEntryArray.length; ++i) {
            keyTabEntryArray[i] = this.entries.elementAt(i);
        }
        return keyTabEntryArray;
    }

    public static synchronized KeyTab create() throws IOException, RealmException {
        String string = KeyTab.getDefaultTabName();
        return KeyTab.create(string);
    }

    public static synchronized KeyTab create(String string) throws IOException, RealmException {
        try (KeyTabOutputStream keyTabOutputStream = new KeyTabOutputStream(new FileOutputStream(string));){
            keyTabOutputStream.writeVersion(1282);
        }
        return new KeyTab(string);
    }

    public synchronized void save() throws IOException {
        try (KeyTabOutputStream keyTabOutputStream = new KeyTabOutputStream(new FileOutputStream(this.tabName));){
            keyTabOutputStream.writeVersion(this.kt_vno);
            for (int i = 0; i < this.entries.size(); ++i) {
                keyTabOutputStream.writeEntry(this.entries.elementAt(i));
            }
        }
    }

    public int deleteEntries(PrincipalName principalName, int n, int n2) {
        int n3;
        KeyTabEntry keyTabEntry;
        int n4;
        int n5 = 0;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (n4 = this.entries.size() - 1; n4 >= 0; --n4) {
            keyTabEntry = this.entries.get(n4);
            if (!principalName.match(keyTabEntry.getService()) || n != -1 && keyTabEntry.keyType != n) continue;
            if (n2 == -2) {
                if (hashMap.containsKey(keyTabEntry.keyType)) {
                    n3 = (Integer)hashMap.get(keyTabEntry.keyType);
                    if (keyTabEntry.keyVersion <= n3) continue;
                    hashMap.put(keyTabEntry.keyType, keyTabEntry.keyVersion);
                    continue;
                }
                hashMap.put(keyTabEntry.keyType, keyTabEntry.keyVersion);
                continue;
            }
            if (n2 != -1 && keyTabEntry.keyVersion != n2) continue;
            this.entries.removeElementAt(n4);
            ++n5;
        }
        if (n2 == -2) {
            for (n4 = this.entries.size() - 1; n4 >= 0; --n4) {
                keyTabEntry = this.entries.get(n4);
                if (!principalName.match(keyTabEntry.getService()) || n != -1 && keyTabEntry.keyType != n || keyTabEntry.keyVersion == (n3 = ((Integer)hashMap.get(keyTabEntry.keyType)).intValue())) continue;
                this.entries.removeElementAt(n4);
                ++n5;
            }
        }
        return n5;
    }

    public synchronized void createVersion(File file) throws IOException {
        try (KeyTabOutputStream keyTabOutputStream = new KeyTabOutputStream(new FileOutputStream(file));){
            keyTabOutputStream.write16(1282);
        }
    }
}

