/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.peer.LabelPeer;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;

class XLabelPeer
extends XComponentPeer
implements LabelPeer {
    static final int TEXT_XPAD = 8;
    static final int TEXT_YPAD = 6;
    String label;
    int alignment;
    FontMetrics cachedFontMetrics;
    Font oldfont;

    FontMetrics getFontMetrics() {
        if (this.cachedFontMetrics != null) {
            return this.cachedFontMetrics;
        }
        return this.getFontMetrics(this.getPeerFont());
    }

    @Override
    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        Label label = (Label)this.target;
        this.label = label.getText();
        if (this.label == null) {
            this.label = "";
        }
        this.alignment = label.getAlignment();
    }

    XLabelPeer(Label label) {
        super(label);
    }

    @Override
    public Dimension getMinimumSize() {
        int n;
        FontMetrics fontMetrics = this.getFontMetrics();
        try {
            n = fontMetrics.stringWidth(this.label);
        }
        catch (NullPointerException nullPointerException) {
            n = 0;
        }
        return new Dimension(n + 8, fontMetrics.getAscent() + fontMetrics.getMaxDescent() + 6);
    }

    @Override
    public void paint(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        graphics.setColor(this.getPeerBackground());
        graphics.fillRect(0, 0, this.width, this.height);
        Font font = this.getPeerFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.cachedFontMetrics == null) {
            this.cachedFontMetrics = fontMetrics;
        } else if (this.oldfont != font) {
            this.cachedFontMetrics = fontMetrics;
        }
        switch (this.alignment) {
            case 0: {
                n = 2;
                n2 = (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2;
                break;
            }
            case 2: {
                n = this.width - (fontMetrics.stringWidth(this.label) + 2);
                n2 = (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2;
                break;
            }
            case 1: {
                n = (this.width - fontMetrics.stringWidth(this.label)) / 2;
                n2 = (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2;
            }
        }
        if (this.isEnabled()) {
            graphics.setColor(this.getPeerForeground());
            graphics.drawString(this.label, n, n2);
        } else {
            graphics.setColor(this.getPeerBackground().brighter());
            graphics.drawString(this.label, n, n2);
            graphics.setColor(this.getPeerBackground().darker());
            graphics.drawString(this.label, n - 1, n2 - 1);
        }
    }

    @Override
    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.label)) {
            this.label = string;
            this.repaint();
        }
    }

    @Override
    public void setAlignment(int n) {
        if (this.alignment != n) {
            this.alignment = n;
            this.repaint();
        }
    }
}

