/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.SetextHeaderMarkerBlock;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0007\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0001\u0019\u0001\u0001\u001a\"\u0007\u0003\n\u0005%\t\u0001$\u0001M\u0001;\u0003M\u0011UA)\u0004\u0003!\rQ%\u0006\u0003\f\u0011\tiA!\u0003\u0002\n\u0003a\u0019\u0001TA\r\u0006\u0011\u000fi1\u0001\u0007\u0003*\u0003a%\u0011d\u0001\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u0001$A\u0013\u0010\t\u0005Ai!\u0004\u0002\r\u0002a9\u0011$\u0002E\u0004\u001b\rAB!K\u0001\u0019\ne\u0019\u0001rB\u0007\u00021!)c\u0002B\u0006\t\u00125\t\u0001$C\r\u0006\u0011\u000fi1\u0001\u0007\u0003*\u0003a%\u0011d\u0001E\b\u001b\u0005A\u0002\u0002"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/SetextHeaderProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "getNextLineFromConstraints", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "interruptsParagraph", "", "Companion"}, moduleName="intellij-markdown")
public final class SetextHeaderProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Regex REGEX;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        if (stateInfo.getParagraphBlock() != null) {
            return CollectionsKt.emptyList();
        }
        MarkdownConstraints currentConstaints = stateInfo.getCurrentConstraints();
        if (Intrinsics.areEqual((Object)stateInfo.getNextConstraints(), (Object)currentConstaints) ^ true) {
            return CollectionsKt.emptyList();
        }
        if (MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, currentConstaints)) {
            Boolean bl;
            CharSequence charSequence = this.getNextLineFromConstraints(pos, currentConstaints);
            if (charSequence != null) {
                void $receiver$iv;
                CharSequence charSequence2 = charSequence;
                CharSequence it = (CharSequence)$receiver$iv;
                bl = Companion.getREGEX().matches(it);
            } else {
                bl = null;
            }
            if (Intrinsics.areEqual(bl, (Object)true)) {
                return CollectionsKt.listOf((Object)new SetextHeaderMarkerBlock(currentConstaints, productionHolder));
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return false;
    }

    private final CharSequence getNextLineFromConstraints(LookaheadText.Position pos, MarkdownConstraints constraints) {
        String string = pos.getNextLine();
        if (string == null) {
            return null;
        }
        String line = string;
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fillFromPrevious(line, 0, constraints);
        if (nextLineConstraints.extendsPrev(constraints)) {
            return nextLineConstraints.eatItselfFromString(line);
        }
        return null;
    }

    static {
        Companion = org.intellij.markdown.parser.markerblocks.providers.SetextHeaderProvider$Companion.INSTANCE;
        REGEX = new Regex("^ {0,3}(\\-+|=+) *$");
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!K\u0006\u0005\u0007\"A\u0019!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011AQ\u0001\u0005\u0004"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/SetextHeaderProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

