/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibrarySupport;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesEditor;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibrarySupportInModuleConfigurable
extends FrameworkSupportInModuleConfigurable {
    @NotNull
    private final RepositoryLibraryDescription libraryDescription;
    @Nullable
    private final Project project;
    private RepositoryLibraryPropertiesEditor editor;
    private RepositoryLibraryPropertiesModel model;

    public RepositoryLibrarySupportInModuleConfigurable(@Nullable Project project, @NotNull RepositoryLibraryDescription libraryDescription) {
        if (libraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescription", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupportInModuleConfigurable", "<init>"));
        }
        this.libraryDescription = libraryDescription;
        this.project = project;
        RepositoryLibraryProperties defaultProperties = libraryDescription.createDefaultProperties();
        this.model = new RepositoryLibraryPropertiesModel(defaultProperties.getVersion(), false, false);
        this.editor = new RepositoryLibraryPropertiesEditor(project, this.model, libraryDescription);
    }

    @Nullable
    public JComponent createComponent() {
        return this.editor.getMainPanel();
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupportInModuleConfigurable", "addSupport"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupportInModuleConfigurable", "addSupport"));
        }
        if (modifiableModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupportInModuleConfigurable", "addSupport"));
        }
        RepositoryLibrarySupport librarySupport = new RepositoryLibrarySupport(this.project == null ? ProjectManager.getInstance().getDefaultProject() : this.project, this.libraryDescription, this.model);
        librarySupport.addSupport(module, rootModel, modifiableModelsProvider);
    }
}

