/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public abstract class MavenOpenOrCreateFilesAction
extends MavenAction {
    @Override
    public void update(AnActionEvent e) {
        String text;
        super.update(e);
        Presentation p = e.getPresentation();
        List<File> files = this.getFiles(e);
        if (files.isEmpty()) {
            p.setEnabled(false);
            return;
        }
        List<VirtualFile> virtualFiles = MavenOpenOrCreateFilesAction.collectVirtualFiles(files);
        boolean enabled = true;
        if (files.size() == 1 && virtualFiles.isEmpty()) {
            text = "Create ''{0}''";
        } else {
            enabled = virtualFiles.size() == files.size();
            text = "Open ''{0}''";
        }
        p.setText(MessageFormat.format(text, files.get(0).getName()));
        p.setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/project/actions/MavenOpenOrCreateFilesAction", "actionPerformed"));
        }
        final Project project = MavenActionUtil.getProject(e.getDataContext());
        if (project == null) {
            return;
        }
        final List<File> files = this.getFiles(e);
        final List<VirtualFile> virtualFiles = MavenOpenOrCreateFilesAction.collectVirtualFiles(files);
        if (files.size() == 1 && virtualFiles.isEmpty()) {
            new WriteCommandAction(project, e.getPresentation().getText(), new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/project/actions/MavenOpenOrCreateFilesAction$1", "run"));
                    }
                    File file = (File)files.get(0);
                    try {
                        VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((String)file.getParent());
                        if (virtualFile != null) {
                            VirtualFile newFile = virtualFile.createChildData((Object)this, file.getName());
                            virtualFiles.add(newFile);
                            MavenUtil.runFileTemplate(project, newFile, MavenOpenOrCreateFilesAction.this.getFileTemplate());
                        }
                    }
                    catch (IOException ex) {
                        MavenUtil.showError(project, "Cannot create " + file.getName(), ex);
                    }
                }
            }.execute();
            return;
        }
        for (VirtualFile each : virtualFiles) {
            new OpenFileDescriptor(project, each).navigate(true);
        }
    }

    private static List<VirtualFile> collectVirtualFiles(List<File> files) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (File each : files) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(each);
            if (virtualFile == null) continue;
            result.add(virtualFile);
        }
        return result;
    }

    protected abstract List<File> getFiles(AnActionEvent var1);

    protected abstract String getFileTemplate();
}

