/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomAntCallParam;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.lang.ant.dom.PropertyProviderFinder;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.DomElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PropertyResolver
extends PropertyProviderFinder {
    private final String myPropertyName;
    private PropertiesProvider myResult;
    private Set<String> myVariants;

    private PropertyResolver(@NotNull String propertyName, DomElement contextElement) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/lang/ant/dom/PropertyResolver", "<init>"));
        }
        super(contextElement);
        this.myVariants = new HashSet<String>();
        this.myPropertyName = propertyName;
    }

    @Override
    public void visitAntDomAntCallParam(AntDomAntCallParam antCallParam) {
    }

    @NotNull
    public static Trinity<PsiElement, Collection<String>, PropertiesProvider> resolve(@NotNull AntDomProject project, @NotNull String propertyName, DomElement contextElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ant/dom/PropertyResolver", "resolve"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/lang/ant/dom/PropertyResolver", "resolve"));
        }
        PropertyResolver resolver = new PropertyResolver(propertyName, contextElement);
        resolver.execute(project, project.getDefaultTarget().getRawText());
        if (resolver.getContextElement() instanceof PropertiesProvider) {
            resolver.propertyProviderFound((PropertiesProvider)((Object)resolver.getContextElement()));
        }
        Trinity<PsiElement, Collection<String>, PropertiesProvider> trinity = resolver.getResult();
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/PropertyResolver", "resolve"));
        }
        return trinity;
    }

    @NotNull
    public Trinity<PsiElement, Collection<String>, PropertiesProvider> getResult() {
        PsiElement element = this.myResult != null ? this.myResult.getNavigationElement(this.myPropertyName) : null;
        Trinity trinity = new Trinity((Object)element, Collections.unmodifiableSet(this.myVariants), (Object)this.myResult);
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/PropertyResolver", "getResult"));
        }
        return trinity;
    }

    @Override
    protected void propertyProviderFound(PropertiesProvider propertiesProvider) {
        boolean found = false;
        Iterator<String> it = propertiesProvider.getNamesIterator();
        while (it.hasNext()) {
            String providerProperty = it.next();
            this.myVariants.add(providerProperty);
            if (!this.myPropertyName.equals(providerProperty)) continue;
            found = true;
        }
        if (found) {
            this.myResult = propertiesProvider;
            this.stop();
        }
    }
}

