/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;
import org.jetbrains.idea.devkit.util.PsiUtil;

abstract class DescriptionNotFoundInspectionBase
extends DevKitInspectionBase {
    private final DescriptionType myDescriptionType;

    protected DescriptionNotFoundInspectionBase(DescriptionType descriptionType) {
        this.myDescriptionType = descriptionType;
    }

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase", "checkClass"));
        }
        Project project = aClass.getProject();
        PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (nameIdentifier == null || module == null || !PsiUtil.isInstantiable(aClass)) {
            return null;
        }
        PsiClass base = JavaPsiFacade.getInstance((Project)project).findClass(this.getClassName(), GlobalSearchScope.allScope((Project)project));
        if (base == null || !aClass.isInheritor(base, true)) {
            return null;
        }
        String descriptionDir = DescriptionCheckerUtil.getDescriptionDirName(aClass);
        if (StringUtil.isEmptyOrSpaces((String)descriptionDir)) {
            return null;
        }
        for (PsiDirectory description : this.getDescriptionsDirs(module)) {
            PsiFile descr;
            PsiDirectory dir = description.findSubdirectory(descriptionDir);
            if (dir == null || (descr = dir.findFile("description.html")) == null) continue;
            if (!DescriptionNotFoundInspectionBase.hasBeforeAndAfterTemplate(dir.getVirtualFile())) {
                PsiIdentifier problem = aClass.getNameIdentifier();
                ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)(problem == null ? nameIdentifier : problem), this.getHasNotBeforeAfterError(), isOnTheFly, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
                return new ProblemDescriptor[]{problemDescriptor};
            }
            return null;
        }
        PsiIdentifier problem = aClass.getNameIdentifier();
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)(problem == null ? nameIdentifier : problem), this.getHasNotDescriptionError(), isOnTheFly, new LocalQuickFix[]{this.getFix(module, descriptionDir)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        return new ProblemDescriptor[]{problemDescriptor};
    }

    protected CreateHtmlDescriptionFix getFix(Module module, String descriptionDir) {
        return new CreateHtmlDescriptionFix(descriptionDir, module, this.myDescriptionType);
    }

    private static boolean hasBeforeAndAfterTemplate(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase", "hasBeforeAndAfterTemplate"));
        }
        boolean hasBefore = false;
        boolean hasAfter = false;
        for (VirtualFile file : dir.getChildren()) {
            String name = file.getName();
            if (!name.endsWith(".template")) continue;
            if (name.startsWith("before.")) {
                hasBefore = true;
                continue;
            }
            if (!name.startsWith("after.")) continue;
            hasAfter = true;
        }
        return hasBefore && hasAfter;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    protected String getClassName() {
        String string = this.myDescriptionType.getClassName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase", "getClassName"));
        }
        return string;
    }

    @NotNull
    protected PsiDirectory[] getDescriptionsDirs(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase", "getDescriptionsDirs"));
        }
        PsiDirectory[] psiDirectoryArray = DescriptionCheckerUtil.getDescriptionsDirs(module, this.myDescriptionType);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase", "getDescriptionsDirs"));
        }
        return psiDirectoryArray;
    }

    @NotNull
    protected abstract String getHasNotDescriptionError();

    @NotNull
    protected abstract String getHasNotBeforeAfterError();
}

