/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImplKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001C\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0005!\u0019\u0001B\n\r\u0001e\t\u0001\u0014AQ\u000b\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000b\t6!\u0001\u0005\u0004K\u001dAa!D\u0001\u0019\u000ee\u0019\u0001bB\u0007\u00021\u0013)C\u0002B\"\u0005\u0011\u001fi!\u0001$\u0001\u0019\u0011e\u0019\u0001bB\u0007\u00021\u0013\t6!\u0001E\tK3!1\t\u0002\u0005\n\u001b\u0005Aj!G\u0002\t\u000f5\t\u0001\u0014B\r\u0004\u0011'i\u0011\u0001\u0007\u0005*\u000f\u0011\t\u0005\u0002C\u0001\u000e\u0003a\r\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00055\t\u0001TA)\u0004\u0003\u0015\u0001\u0011\u0006\u0004\u0003B\u0011!\u001dQ\"\u0001\r\u0005+\u0005AJ\u0001H\u0011R\u0007\ri!\u0001B\u0003\t\f\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/build/MarkerFile;", "", "fileName", "", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "(Ljava/lang/String;Lorg/jetbrains/jps/builders/storage/BuildDataPaths;)V", "markerFile", "Ljava/io/File;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "getMarkerFile", "(Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)Ljava/io/File;", "clean", "", "target", "get", "", "(Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)Ljava/lang/Boolean;", "set", "value"}, moduleName="jps-plugin")
public abstract class MarkerFile {
    private final String fileName;
    private final BuildDataPaths paths;

    @Nullable
    public final Boolean get(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        File file = this.getMarkerFile(target);
        if (!file.exists()) {
            return null;
        }
        return StringsKt.toBoolean((String)FilesKt.readText$default((File)file, null, (int)1));
    }

    public final void set(@NotNull ModuleBuildTarget target, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        File file = this.getMarkerFile(target);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FilesKt.writeText$default((File)file, (String)String.valueOf(value), null, (int)2);
    }

    public final void clean(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.getMarkerFile(target).delete();
    }

    private final File getMarkerFile(ModuleBuildTarget $receiver) {
        File directory = new File(this.paths.getTargetDataRoot((BuildTarget)$receiver), IncrementalCacheImplKt.getKOTLIN_CACHE_DIRECTORY_NAME());
        return new File(directory, this.fileName);
    }

    public MarkerFile(@NotNull String fileName, @NotNull BuildDataPaths paths) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        this.fileName = fileName;
        this.paths = paths;
    }
}

