/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildTargetRegistryImpl;
import org.jetbrains.jps.builders.impl.TargetOutputIndexImpl;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.jps.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"W\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005A\u0019#B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u001d\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001BE\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ\u0012\u0004\u0003\u0002\u0011\u001biA!\u0003\u0002\n\u0003a\r\u0001$A\r\u0004\u0011\u001di\u0011\u0001g\u0004U\u0007\u000bi9\u0003B\u0001\t\u001159\u0011BA\u0005\u00021\u000fI!!C\u0001\u0019\u0013aE\u0011d\u0001E\n\u001b\u0005A\"\"G\u0002\t\u000f5\t\u0001t\u0002+\u0004\u00065MA!\u0001E\u000b\u001b\u0005A2\"G\u0002\t\u00185\t\u0001\u0004\u0004+\u0004\u00065eA!\u0001E\r\u001b\u0011I!!C\u0001\u0019\ba\t\u0011d\u0001\u0005\b\u001b\u0005Az\u0001VB\u0003\u001bO!\u0011\u0001C\u0007\u000e\u0003am\u0011$\u0003\u0005\u000f\u001b\u001dI!!C\u0001\u0019\u001f%\u0011\u0011\"\u0001M\u00041;I2\u0001c\u0005\u000e\u0003aQAk!\u0002\u0012N\u0011\t\u0005\u0002\u0003\u0001\u000e?%a\u0011bC\u0005\u0003\u0013\u0005A\u001a\u0001\u0005\u0002\u0016\u000b%\u0011\u0011\"\u0001M\u0002\u0019\u0003A\u0012\u0001G\u0001\u0011\u0005Uy\u0011\u0002D\u0005\f\u0013\tI\u0011\u0001g\u0001\u0011\u0005U)\u0011BA\u0005\u00021\u0007a\t\u0001G\u0001\u0019\u00031\u0005\u0001\u0014\u0001M\u0001#\u000e\tQ\u0001\u0001+\u0004\u0006E5C!\u0011\u0005\t\u00075y\u0012\u0002D\u0005\f\u0013\tI\u0011\u0001g\u0002\u0011\u0005U)\u0011BA\u0005\u00021\u000fa\t\u0001G\u0001\u0019\u0003A\u0011QcD\u0005\r\u0013-I!!C\u0001\u0019\bA\u0011Q#B\u0005\u0003\u0013\u0005A:\u0001$\u0001\u0019\u0003a\tA\u0012\u0001M\u00011\u0003\t6!A\u0003\u0001)\u000e\u0015\u00113\u0006\u0003B\u0011!!Q\u0002B\u0005\u0003\u0013\u0005A:\u0001'\u0003\u0016\r%!\u0011bA\u0005\u0002\t\u0007AR\u0001'\u0003\u001dCE\u001b1!\u0004\u0002\u0005\f!1Ak!\u0002"}, strings={"ALL_COMPILED_FILES_KEY", "Lcom/intellij/openapi/util/Key;", "", "Ljava/io/File;", "kotlin.jvm.PlatformType", "KotlinBuilderKt", "PROCESSED_TARGETS_WITH_REMOVED_FILES", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "moduleTargets", "", "Lorg/jetbrains/jps/builders/BuildTarget;", "getModuleTargets", "(Ljava/lang/Iterable;)Ljava/lang/Iterable;", "getAllCompiledFilesContainer", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "getIncrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "getLookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "project", "Lorg/jetbrains/jps/model/JpsProject;", "getProcessedTargetsWithRemovedFilesContainer", "hasKotlinDirtyOrRemovedFiles", "", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;"}, moduleName="jps-plugin")
public final class KotlinBuilderKt {
    private static final Key<Set<File>> ALL_COMPILED_FILES_KEY = Key.create((String)"_all_kotlin_compiled_files_");
    private static final Key<Set<ModuleBuildTarget>> PROCESSED_TARGETS_WITH_REMOVED_FILES = Key.create((String)"_processed_targets_with_removed_files_");

    private static final Iterable<ModuleBuildTarget> getModuleTargets(Iterable<? extends BuildTarget<?>> $receiver) {
        return kotlin.collections.CollectionsKt.filterIsInstance($receiver, ModuleBuildTarget.class);
    }

    private static final LookupTracker getLookupTracker(JpsProject project) {
        LookupTracker lookupTracker = LookupTracker.Companion.getDO_NOTHING();
        if (StringsKt.equals((String)"true", (String)System.getProperty("kotlin.jps.tests"), (boolean)true)) {
            LookupTracker testTracker;
            JpsSimpleElement jpsSimpleElement = (JpsSimpleElement)project.getContainer().getChild((JpsElementChildRole)KotlinBuilder.Companion.getLOOKUP_TRACKER());
            Object object = testTracker = jpsSimpleElement != null ? (LookupTracker)jpsSimpleElement.getData() : null;
            if (testTracker != null) {
                lookupTracker = testTracker;
            }
        }
        if (IncrementalCompilation.isExperimental()) {
            return new LookupTrackerImpl(lookupTracker);
        }
        return lookupTracker;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<ModuleBuildTarget, IncrementalCacheImpl> getIncrementalCaches(ModuleChunk chunk, CompileContext context) {
        void $receiver$iv;
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        Set targets = chunk.getTargets();
        BuildTargetRegistryImpl buildRegistry = new BuildTargetRegistryImpl(context.getProjectDescriptor().getModel());
        TargetOutputIndexImpl outputIndex = new TargetOutputIndexImpl((Collection)targets, context);
        Iterable<ModuleBuildTarget> allTargets = KotlinBuilderKt.getModuleTargets(buildRegistry.getAllTargets());
        Map allDependencies2 = CollectionsKt.keysToMap(allTargets, (Function1)new Function1<ModuleBuildTarget, Iterable<? extends ModuleBuildTarget>>(buildRegistry, outputIndex){
            final /* synthetic */ BuildTargetRegistryImpl $buildRegistry;
            final /* synthetic */ TargetOutputIndexImpl $outputIndex;

            @NotNull
            public final Iterable<ModuleBuildTarget> invoke(@NotNull ModuleBuildTarget target) {
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                return KotlinBuilderKt.access$getModuleTargets$p(target.computeDependencies((BuildTargetRegistry)this.$buildRegistry, (TargetOutputIndex)this.$outputIndex));
            }
            {
                this.$buildRegistry = buildTargetRegistryImpl;
                this.$outputIndex = targetOutputIndexImpl;
                super(1);
            }
        });
        Map dependents2 = CollectionsKt.keysToMap(targets, (Function1)getIncrementalCaches.dependents.1.INSTANCE);
        HashSet<ModuleBuildTarget> targetsWithDependents = new HashSet<ModuleBuildTarget>(targets);
        Object object = MapsKt.iterator(allDependencies2);
        while (object.hasNext()) {
            void $receiver$iv2;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)object.next();
            ModuleBuildTarget target = (ModuleBuildTarget)$receiver$iv2.getKey();
            Map.Entry $i$f$component1 = entry;
            Iterable dependencies = (Iterable)$receiver$iv.getValue();
            for (Object dependency : dependencies) {
                if (targets.contains(dependency) ^ true) continue;
                Object v = dependents2.get(dependency);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                ((HashSet)v).add(target);
                targetsWithDependents.add(target);
            }
        }
        Map<ModuleBuildTarget, IncrementalCacheImpl> caches2 = CollectionsKt.keysToMap((Iterable)targetsWithDependents, (Function1)new Function1<ModuleBuildTarget, IncrementalCacheImpl>(dataManager){
            final /* synthetic */ BuildDataManager $dataManager;

            @NotNull
            public final IncrementalCacheImpl invoke(@NotNull ModuleBuildTarget it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return IncrementalCacheImplKt.getKotlinCache(this.$dataManager, it);
            }
            {
                this.$dataManager = buildDataManager;
                super(1);
            }
        });
        Iterator iterator2 = MapsKt.iterator(caches2);
        while (iterator2.hasNext()) {
            Unit unit;
            Iterable $receiver$iv3;
            Object dependency;
            dependency = object = (Map.Entry)iterator2.next();
            ModuleBuildTarget target = (ModuleBuildTarget)$receiver$iv.getKey();
            Object $i$f$component1 = object;
            IncrementalCacheImpl cache = (IncrementalCacheImpl)$receiver$iv3.getValue();
            HashSet hashSet = (HashSet)dependents2.get(target);
            if (hashSet != null) {
                $receiver$iv3 = hashSet;
                for (Object element$iv : $receiver$iv3) {
                    ModuleBuildTarget it = (ModuleBuildTarget)element$iv;
                    IncrementalCacheImpl incrementalCacheImpl = caches2.get(it);
                    if (incrementalCacheImpl == null) {
                        Intrinsics.throwNpe();
                    }
                    cache.addDependentCache(incrementalCacheImpl);
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        return caches2;
    }

    private static final Set<File> getAllCompiledFilesContainer(CompileContext context) {
        Set allCompiledFiles = (Set)ALL_COMPILED_FILES_KEY.get((UserDataHolder)context);
        if (allCompiledFiles == null) {
            allCompiledFiles = (Set)new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            ALL_COMPILED_FILES_KEY.set((UserDataHolder)context, (Object)allCompiledFiles);
        }
        return allCompiledFiles;
    }

    private static final Set<ModuleBuildTarget> getProcessedTargetsWithRemovedFilesContainer(CompileContext context) {
        Set set = (Set)PROCESSED_TARGETS_WITH_REMOVED_FILES.get((UserDataHolder)context);
        if (set == null) {
            set = new HashSet();
            PROCESSED_TARGETS_WITH_REMOVED_FILES.set((UserDataHolder)context, (Object)set);
        }
        return set;
    }

    private static final boolean hasKotlinDirtyOrRemovedFiles(DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleChunk chunk) {
        boolean bl;
        block3: {
            if (!dirtyFilesHolder.hasDirtyFiles() && !dirtyFilesHolder.hasRemovedFiles()) {
                return false;
            }
            if (!KotlinSourceFileCollector.getDirtySourceFiles(dirtyFilesHolder).isEmpty()) {
                return true;
            }
            Iterable $receiver$iv = chunk.getTargets();
            for (Object element$iv : $receiver$iv) {
                ModuleBuildTarget it = (ModuleBuildTarget)element$iv;
                if (!kotlin.collections.CollectionsKt.isNotEmpty((Collection)KotlinSourceFileCollector.getRemovedKotlinFiles(dirtyFilesHolder, it))) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasKotlinDirtyOrRemovedFiles(@NotNull DirtyFilesHolder dirtyFilesHolder, @NotNull ModuleChunk chunk) {
        return KotlinBuilderKt.hasKotlinDirtyOrRemovedFiles((DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder, chunk);
    }

    @NotNull
    public static final /* synthetic */ LookupTracker access$getLookupTracker(@NotNull JpsProject project) {
        return KotlinBuilderKt.getLookupTracker(project);
    }

    @NotNull
    public static final /* synthetic */ Map access$getIncrementalCaches(@NotNull ModuleChunk chunk, @NotNull CompileContext context) {
        return KotlinBuilderKt.getIncrementalCaches(chunk, context);
    }

    @NotNull
    public static final /* synthetic */ Set access$getAllCompiledFilesContainer(@NotNull CompileContext context) {
        return KotlinBuilderKt.getAllCompiledFilesContainer(context);
    }

    @NotNull
    public static final /* synthetic */ Set access$getProcessedTargetsWithRemovedFilesContainer(@NotNull CompileContext context) {
        return KotlinBuilderKt.getProcessedTargetsWithRemovedFilesContainer(context);
    }

    @NotNull
    public static final /* synthetic */ Iterable access$getModuleTargets$p(Iterable $receiver) {
        return KotlinBuilderKt.getModuleTargets($receiver);
    }
}

