/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2;

import com.intellij.execution.junit2.TestProxyListener;
import com.intellij.execution.testframework.AbstractTestProxy;
import java.util.ArrayList;

public class TestProxyListenersNotifier
implements TestProxyListener {
    private ArrayList<TestProxyListener> myListeners;
    private TestProxyListener[] myCachedListeners;

    public void addListener(TestProxyListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList();
        }
        if (this.myListeners.contains(listener)) {
            return;
        }
        this.myListeners.add(listener);
        this.myCachedListeners = null;
    }

    @Override
    public void onChanged(AbstractTestProxy test) {
        TestProxyListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].onChanged(test);
        }
    }

    @Override
    public void onChildAdded(AbstractTestProxy testProxy, AbstractTestProxy child) {
        TestProxyListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].onChildAdded(testProxy, child);
        }
    }

    private TestProxyListener[] getListeners() {
        if (this.myCachedListeners == null) {
            int size = this.myListeners != null ? this.myListeners.size() : 0;
            this.myCachedListeners = size != 0 ? this.myListeners.toArray(new TestProxyListener[size]) : TestProxyListener.EMPTY_ARRAY;
        }
        return this.myCachedListeners;
    }

    @Override
    public void onStatisticsChanged(AbstractTestProxy test) {
        TestProxyListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            TestProxyListener listener = listeners[i];
            listener.onStatisticsChanged(test);
        }
    }
}

