/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.branchConfig.ConfigureBranchesAction;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.MergeInfoUpdatesListener;
import org.jetbrains.idea.svn.history.MergeSourceHierarchyBuilder;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.history.ShowHideMergePanelAction;
import org.jetbrains.idea.svn.history.SingleCommittedListProvider;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedListsZipper;
import org.jetbrains.idea.svn.history.SvnMergeSourceTracker;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.SvnVersionFilterComponent;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnCommittedChangesProvider
implements CachingCommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance(SvnCommittedChangesProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final MessageBusConnection myConnection;
    private MergeInfoUpdatesListener myMergeInfoUpdatesListener;
    @NotNull
    private final SvnCommittedListsZipper myZipper;
    public static final int VERSION_WITH_COPY_PATHS_ADDED = 2;
    public static final int VERSION_WITH_REPLACED_PATHS = 3;

    public SvnCommittedChangesProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "<init>"));
        }
        this.myProject = project;
        this.myVcs = SvnVcs.getInstance(this.myProject);
        this.myZipper = new SvnCommittedListsZipper(this.myVcs);
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(VcsConfigurationChangeListener.BRANCHES_CHANGED_RESPONSE, (Object)new VcsConfigurationChangeListener.DetailedNotification(){

            public void execute(final Project project, final VirtualFile vcsRoot, final List<CommittedChangeList> cachedList) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (project.isDisposed()) {
                            return;
                        }
                        for (CommittedChangeList committedChangeList : cachedList) {
                            if (!(committedChangeList instanceof SvnChangeList) || vcsRoot != null && !vcsRoot.equals(((SvnChangeList)committedChangeList).getVcsRoot())) continue;
                            ((SvnChangeList)committedChangeList).forceReloadCachedInfo(true);
                        }
                    }
                });
            }
        });
    }

    @NotNull
    public ChangeBrowserSettings createDefaultSettings() {
        ChangeBrowserSettings changeBrowserSettings = new ChangeBrowserSettings();
        if (changeBrowserSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createDefaultSettings"));
        }
        return changeBrowserSettings;
    }

    @NotNull
    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        SvnVersionFilterComponent svnVersionFilterComponent = new SvnVersionFilterComponent(showDateFilter);
        if (svnVersionFilterComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createFilterUI"));
        }
        return svnVersionFilterComponent;
    }

    @Nullable
    public RepositoryLocation getLocationFor(@NotNull FilePath root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getLocationFor"));
        }
        String url = SvnUtil.getExactLocation(this.myVcs, root.getIOFile());
        return url == null ? null : new SvnRepositoryLocation(url, root);
    }

    @Nullable
    public RepositoryLocation getLocationFor(@NotNull FilePath root, @Nullable String repositoryPath) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getLocationFor"));
        }
        return repositoryPath == null ? this.getLocationFor(root) : new SvnRepositoryLocation(repositoryPath);
    }

    @NotNull
    public VcsCommittedListsZipper getZipper() {
        SvnCommittedListsZipper svnCommittedListsZipper = this.myZipper;
        if (svnCommittedListsZipper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getZipper"));
        }
        return svnCommittedListsZipper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount, final @NotNull AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "loadCommittedChanges"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "loadCommittedChanges"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "loadCommittedChanges"));
        }
        try {
            final SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
            final String repositoryRoot = this.getRepositoryRoot(svnLocation);
            final ChangeBrowserSettings.Filter filter = settings.createFilter();
            this.getCommittedChangesImpl(settings, svnLocation, maxCount, new Consumer<LogEntry>(){

                public void consume(LogEntry svnLogEntry) {
                    SvnChangeList cl = new SvnChangeList(SvnCommittedChangesProvider.this.myVcs, svnLocation, svnLogEntry, repositoryRoot);
                    if (filter.accepts((CommittedChangeList)cl)) {
                        consumer.consume((Object)cl);
                    }
                }
            }, false, true);
        }
        finally {
            consumer.finished();
        }
    }

    @NotNull
    public List<SvnChangeList> getCommittedChanges(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount) throws VcsException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChanges"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChanges"));
        }
        final SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        final ArrayList<SvnChangeList> result = new ArrayList<SvnChangeList>();
        final String repositoryRoot = this.getRepositoryRoot(svnLocation);
        this.getCommittedChangesImpl(settings, svnLocation, maxCount, new Consumer<LogEntry>(){

            public void consume(LogEntry svnLogEntry) {
                result.add(new SvnChangeList(SvnCommittedChangesProvider.this.myVcs, svnLocation, svnLogEntry, repositoryRoot));
            }
        }, false, true);
        settings.filterChanges(result);
        ArrayList<SvnChangeList> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChanges"));
        }
        return arrayList;
    }

    public void getCommittedChangesWithMergedRevisons(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount, final @NotNull PairConsumer<SvnChangeList, LogHierarchyNode> finalConsumer) throws VcsException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChangesWithMergedRevisons"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChangesWithMergedRevisons"));
        }
        if (finalConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalConsumer", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChangesWithMergedRevisons"));
        }
        final SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        final String repositoryRoot = this.getRepositoryRoot(svnLocation);
        final MergeSourceHierarchyBuilder builder = new MergeSourceHierarchyBuilder(new Consumer<LogHierarchyNode>(){

            public void consume(LogHierarchyNode node) {
                finalConsumer.consume((Object)new SvnChangeList(SvnCommittedChangesProvider.this.myVcs, svnLocation, node.getMe(), repositoryRoot), (Object)node);
            }
        });
        final SvnMergeSourceTracker mergeSourceTracker = new SvnMergeSourceTracker(new ThrowableConsumer<Pair<LogEntry, Integer>, SVNException>(){

            public void consume(Pair<LogEntry, Integer> svnLogEntryIntegerPair) throws SVNException {
                builder.consume(svnLogEntryIntegerPair);
            }
        });
        this.getCommittedChangesImpl(settings, SvnTarget.fromURL((SVNURL)svnLocation.toSvnUrl()), maxCount, new Consumer<LogEntry>(){

            public void consume(LogEntry svnLogEntry) {
                try {
                    mergeSourceTracker.consume(svnLogEntry);
                }
                catch (SVNException e) {
                    throw new RuntimeException(e);
                }
            }
        }, true, false);
        builder.finish();
    }

    @NotNull
    private String getRepositoryRoot(@NotNull SvnRepositoryLocation svnLocation) throws VcsException {
        if (svnLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svnLocation", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getRepositoryRoot"));
        }
        SVNURL rootUrl = SvnUtil.getRepositoryRoot(this.myVcs, svnLocation.toSvnUrl());
        if (rootUrl == null) {
            throw new SvnBindException("Could not resolve repository root url for " + svnLocation);
        }
        String string = rootUrl.toDecodedString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getRepositoryRoot"));
        }
        return string;
    }

    private void getCommittedChangesImpl(@NotNull ChangeBrowserSettings settings, @NotNull SvnRepositoryLocation location, int maxCount, @NotNull Consumer<LogEntry> resultConsumer, boolean includeMergedRevisions, boolean filterOutByDate) throws VcsException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChangesImpl"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChangesImpl"));
        }
        if (resultConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultConsumer", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChangesImpl"));
        }
        SvnTarget target = SvnTarget.fromURL((SVNURL)location.toSvnUrl(), (SVNRevision)SvnCommittedChangesProvider.createBeforeRevision(settings));
        this.getCommittedChangesImpl(settings, target, maxCount, resultConsumer, includeMergedRevisions, filterOutByDate);
    }

    private void getCommittedChangesImpl(@NotNull ChangeBrowserSettings settings, @NotNull SvnTarget target, int maxCount, @NotNull Consumer<LogEntry> resultConsumer, boolean includeMergedRevisions, boolean filterOutByDate) throws VcsException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChangesImpl"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChangesImpl"));
        }
        if (resultConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultConsumer", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getCommittedChangesImpl"));
        }
        SvnCommittedChangesProvider.setCollectingChangesProgress(target.getPathOrUrlString());
        String author = settings.getUserFilter();
        SVNRevision revisionBefore = SvnCommittedChangesProvider.createBeforeRevision(settings);
        SVNRevision revisionAfter = SvnCommittedChangesProvider.createAfterRevision(settings);
        this.myVcs.getFactory(target).createHistoryClient().doLog(target, revisionBefore, revisionAfter, settings.STOP_ON_COPY, true, includeMergedRevisions, maxCount, null, this.createLogHandler(resultConsumer, filterOutByDate, author));
    }

    @NotNull
    private static SVNRevision createBeforeRevision(@NotNull ChangeBrowserSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createBeforeRevision"));
        }
        SVNRevision sVNRevision = SvnCommittedChangesProvider.createRevision(settings.getDateBeforeFilter(), settings.getChangeBeforeFilter(), SVNRevision.HEAD);
        if (sVNRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createBeforeRevision"));
        }
        return sVNRevision;
    }

    @NotNull
    private static SVNRevision createAfterRevision(@NotNull ChangeBrowserSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createAfterRevision"));
        }
        SVNRevision sVNRevision = SvnCommittedChangesProvider.createRevision(settings.getDateAfterFilter(), settings.getChangeAfterFilter(), SVNRevision.create((long)1L));
        if (sVNRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createAfterRevision"));
        }
        return sVNRevision;
    }

    @NotNull
    private static SVNRevision createRevision(@Nullable Date date, @Nullable Long change, @NotNull SVNRevision defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createRevision"));
        }
        SVNRevision result = date != null ? SVNRevision.create((Date)date) : (change != null ? SVNRevision.create((long)change) : defaultValue);
        SVNRevision sVNRevision = result;
        if (sVNRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createRevision"));
        }
        return sVNRevision;
    }

    @NotNull
    private LogEntryConsumer createLogHandler(final @NotNull Consumer<LogEntry> resultConsumer, final boolean filterOutByDate, final @Nullable String author) {
        if (resultConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultConsumer", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createLogHandler"));
        }
        LogEntryConsumer logEntryConsumer = new LogEntryConsumer(){

            public void consume(LogEntry logEntry) {
                if (SvnCommittedChangesProvider.this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                ProgressManager.progress2((String)SvnBundle.message("progress.text2.processing.revision", logEntry.getRevision()));
                if (filterOutByDate && logEntry.getDate() == null) {
                    return;
                }
                if (author == null || author.equalsIgnoreCase(logEntry.getAuthor())) {
                    resultConsumer.consume((Object)logEntry);
                }
            }
        };
        if (logEntryConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createLogHandler"));
        }
        return logEntryConsumer;
    }

    private static void setCollectingChangesProgress(@Nullable Object location) {
        ProgressManager.progress((String)SvnBundle.message("progress.text.changes.collecting.changes", new Object[0]), (String)SvnBundle.message("progress.text2.changes.establishing.connection", location));
    }

    @NotNull
    public ChangeListColumn[] getColumns() {
        ChangeListColumn[] changeListColumnArray = new ChangeListColumn[]{new ChangeListColumn.ChangeListNumberColumn(SvnBundle.message("revision.title", new Object[0])), ChangeListColumn.NAME, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION};
        if (changeListColumnArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getColumns"));
        }
        return changeListColumnArray;
    }

    private void refreshMergeInfo(@NotNull RootsAndBranches action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "refreshMergeInfo"));
        }
        if (this.myMergeInfoUpdatesListener == null) {
            this.myMergeInfoUpdatesListener = new MergeInfoUpdatesListener(this.myProject, this.myConnection);
        }
        this.myMergeInfoUpdatesListener.addPanel(action);
    }

    @NotNull
    public VcsCommittedViewAuxiliary createActions(@NotNull DecoratorManager manager, @Nullable RepositoryLocation location) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createActions"));
        }
        final RootsAndBranches rootsAndBranches = new RootsAndBranches(this.myVcs, manager, location);
        this.refreshMergeInfo(rootsAndBranches);
        DefaultActionGroup popup = new DefaultActionGroup(this.myVcs.getDisplayName(), true);
        popup.add((AnAction)rootsAndBranches.getIntegrateAction());
        popup.add((AnAction)rootsAndBranches.getUndoIntegrateAction());
        popup.add((AnAction)new ConfigureBranchesAction());
        ShowHideMergePanelAction action = new ShowHideMergePanelAction(manager, rootsAndBranches.getStrategy());
        VcsCommittedViewAuxiliary vcsCommittedViewAuxiliary = new VcsCommittedViewAuxiliary(Collections.singletonList(popup), new Runnable(){

            @Override
            public void run() {
                if (SvnCommittedChangesProvider.this.myMergeInfoUpdatesListener != null) {
                    SvnCommittedChangesProvider.this.myMergeInfoUpdatesListener.removePanel(rootsAndBranches);
                    rootsAndBranches.dispose();
                }
            }
        }, Collections.singletonList(action));
        if (vcsCommittedViewAuxiliary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "createActions"));
        }
        return vcsCommittedViewAuxiliary;
    }

    public int getUnlimitedCountValue() {
        return 0;
    }

    @Nullable
    public Pair<SvnChangeList, FilePath> getOneList(@NotNull VirtualFile file, @NotNull VcsRevisionNumber number) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getOneList"));
        }
        if (number == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getOneList"));
        }
        return new SingleCommittedListProvider(this.myVcs, file, number).run();
    }

    @NotNull
    public RepositoryLocation getForNonLocal(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getForNonLocal"));
        }
        SvnRepositoryLocation svnRepositoryLocation = new SvnRepositoryLocation(FileUtil.toSystemIndependentName((String)file.getPresentableUrl()));
        if (svnRepositoryLocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getForNonLocal"));
        }
        return svnRepositoryLocation;
    }

    public boolean supportsIncomingChanges() {
        return true;
    }

    public int getFormatVersion() {
        return 3;
    }

    public void writeChangeList(@NotNull DataOutput dataStream, @NotNull SvnChangeList list) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "writeChangeList"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "writeChangeList"));
        }
        list.writeToStream(dataStream);
    }

    @NotNull
    public SvnChangeList readChangeList(@NotNull RepositoryLocation location, @NotNull DataInput stream) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "readChangeList"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "readChangeList"));
        }
        int version = this.getFormatVersion();
        SvnChangeList svnChangeList = new SvnChangeList(this.myVcs, (SvnRepositoryLocation)location, stream, 2 <= version, 3 <= version);
        if (svnChangeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "readChangeList"));
        }
        return svnChangeList;
    }

    public boolean isMaxCountSupported() {
        return true;
    }

    @Nullable
    public Collection<FilePath> getIncomingFiles(@NotNull RepositoryLocation location) throws VcsException {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getIncomingFiles"));
        }
        FilePath root = null;
        if (Registry.is((String)"svn.use.incoming.optimization") && (root = ((SvnRepositoryLocation)location).getRoot()) == null) {
            LOG.info("Working copy root is not provided for repository location " + location);
        }
        return root != null ? this.getIncomingFiles(root) : null;
    }

    @NotNull
    private Collection<FilePath> getIncomingFiles(@NotNull FilePath root) throws SvnBindException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getIncomingFiles"));
        }
        final HashSet result = ContainerUtil.newHashSet();
        File rootFile = root.getIOFile();
        this.myVcs.getFactory(rootFile).createStatusClient().doStatus(rootFile, SVNRevision.UNDEFINED, Depth.INFINITY, true, false, false, false, new StatusConsumer(){

            public void consume(Status status) throws SVNException {
                boolean changedOnServer;
                File file = status.getFile();
                boolean bl = changedOnServer = SvnCommittedChangesProvider.isNotNone(status.getRemoteContentsStatus()) || SvnCommittedChangesProvider.isNotNone(status.getRemoteNodeStatus()) || SvnCommittedChangesProvider.isNotNone(status.getRemotePropertiesStatus());
                if (file != null && changedOnServer) {
                    result.add(VcsUtil.getFilePath((File)file, (boolean)file.isDirectory()));
                }
            }
        }, null);
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider", "getIncomingFiles"));
        }
        return hashSet;
    }

    private static boolean isNotNone(@Nullable StatusType status) {
        return status != null && !StatusType.STATUS_NONE.equals((Object)status);
    }

    public boolean refreshCacheByNumber() {
        return true;
    }

    public String getChangelistTitle() {
        return SvnBundle.message("changes.browser.revision.term", new Object[0]);
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, SvnChangeList changeList) {
        return localRevision != null && localRevision.compareTo((Object)changeRevision) >= 0;
    }

    public boolean refreshIncomingWithCommitted() {
        return true;
    }

    public void deactivate() {
        this.myConnection.disconnect();
    }
}

