/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopiesContent;

public class MergeFromAction
extends DumbAwareAction {
    public MergeFromAction() {
        super("Merge from...", "One-click merge for feature branches", null);
    }

    public void actionPerformed(AnActionEvent e) {
        if (!this.isEnabled(e)) {
            return;
        }
        DataContext dc = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return;
        }
        WorkingCopiesContent.show(project);
    }

    public void update(AnActionEvent e) {
        DataContext dc = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null || project.isDefault()) {
            return;
        }
        e.getPresentation().setVisible(this.isEnabled(e));
    }

    private boolean isEnabled(AnActionEvent e) {
        DataContext dc = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null || project.isDefault()) {
            return false;
        }
        VirtualFile[] files = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)SvnVcs.getInstance(project));
        return files != null && files.length > 0;
    }
}

