/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;

public class Node {
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final SVNURL myUrl;
    @NotNull
    private final SVNURL myRepositoryUrl;
    @Nullable
    private final SvnBindException myError;

    public Node(@NotNull VirtualFile file, @NotNull SVNURL url, @NotNull SVNURL repositoryUrl) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/Node", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/Node", "<init>"));
        }
        if (repositoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryUrl", "org/jetbrains/idea/svn/Node", "<init>"));
        }
        this(file, url, repositoryUrl, null);
    }

    public Node(@NotNull VirtualFile file, @NotNull SVNURL url, @NotNull SVNURL repositoryUrl, @Nullable SvnBindException error) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/Node", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/Node", "<init>"));
        }
        if (repositoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryUrl", "org/jetbrains/idea/svn/Node", "<init>"));
        }
        this.myFile = file;
        this.myUrl = url;
        this.myRepositoryUrl = repositoryUrl;
        this.myError = error;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/Node", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public File getIoFile() {
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/Node", "getIoFile"));
        }
        return file;
    }

    @NotNull
    public SVNURL getUrl() {
        SVNURL sVNURL = this.myUrl;
        if (sVNURL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/Node", "getUrl"));
        }
        return sVNURL;
    }

    @NotNull
    public SVNURL getRepositoryRootUrl() {
        SVNURL sVNURL = this.myRepositoryUrl;
        if (sVNURL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/Node", "getRepositoryRootUrl"));
        }
        return sVNURL;
    }

    @Nullable
    public SvnBindException getError() {
        return this.myError;
    }

    public boolean hasError() {
        return this.myError != null;
    }

    public boolean onUrl(@Nullable SVNURL url) {
        return this.myUrl.equals((Object)url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        if (this.myError != null ? node.myError == null || !this.myError.getMessage().equals(node.myError.getMessage()) : node.myError != null) {
            return false;
        }
        if (!this.myFile.equals(node.myFile)) {
            return false;
        }
        if (!this.myRepositoryUrl.equals((Object)node.myRepositoryUrl)) {
            return false;
        }
        return this.myUrl.equals((Object)node.myUrl);
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myUrl.hashCode();
        result = 31 * result + this.myRepositoryUrl.hashCode();
        result = 31 * result + (this.myError != null ? this.myError.getMessage().hashCode() : 0);
        return result;
    }
}

