/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.android.dom.resources.ResourceNameConverter;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidInlineAllStyleUsagesProcessor
extends BaseRefactoringProcessor {
    private final PsiElement myStyleElement;
    private final String myStyleName;
    private final Map<AndroidAttributeInfo, String> myAttributeValues;
    private final StyleRefData myParentStyleRef;
    private final XmlTag myStyleTag;
    private final AndroidInlineTestConfig myTestConfig;

    protected AndroidInlineAllStyleUsagesProcessor(@NotNull Project project, @NotNull PsiElement styleElement, @NotNull XmlTag styleTag, @NotNull String styleName, @NotNull Map<AndroidAttributeInfo, String> attributeValues, @Nullable StyleRefData parentStyleRef, @Nullable AndroidInlineTestConfig config) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor", "<init>"));
        }
        if (styleElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleElement", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor", "<init>"));
        }
        if (styleTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleTag", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor", "<init>"));
        }
        if (styleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleName", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor", "<init>"));
        }
        if (attributeValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValues", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor", "<init>"));
        }
        super(project);
        this.myStyleElement = styleElement;
        this.myStyleTag = styleTag;
        this.myStyleName = styleName;
        this.myAttributeValues = attributeValues;
        this.myParentStyleRef = parentStyleRef;
        this.myTestConfig = config;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor", "createUsageViewDescriptor"));
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{AndroidInlineAllStyleUsagesProcessor.this.myStyleElement};
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor$1", "getElements"));
                }
                return psiElementArray;
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "References to be inlined" + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            public String getProcessedElementsHeader() {
                return "Style to inline";
            }
        };
        if (usageViewDescriptorAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor", "createUsageViewDescriptor"));
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        HashSet usages = new HashSet();
        AndroidInlineUtil.addReferences(this.myStyleElement, (Collection<UsageInfo>)usages);
        for (PsiField field : AndroidResourceUtil.findResourceFieldsForValueResource(this.myStyleTag, false)) {
            AndroidInlineUtil.addReferences((PsiElement)field, (Collection<UsageInfo>)usages);
        }
        UsageInfo[] usageInfoArray = usages.toArray(new UsageInfo[usages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor", "performRefactoring"));
        }
        ArrayList<StyleUsageData> inlineInfos = new ArrayList<StyleUsageData>();
        for (UsageInfo usage : usages) {
            StyleUsageData usageData;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            StyleUsageData styleUsageData = usageData = tag != null ? AndroidInlineUtil.getStyleUsageData(tag) : null;
            if (usageData == null || usageData.getReference().computeTargetElements().length != 1) continue;
            inlineInfos.add(usageData);
        }
        for (StyleUsageData info : inlineInfos) {
            info.inline(this.myAttributeValues, this.myParentStyleRef);
        }
        this.myStyleTag.delete();
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor", "preprocessUsages"));
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap<PsiElement, String> conflicts = AndroidInlineAllStyleUsagesProcessor.detectConflicts(usages);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myTestConfig.setConflicts(conflicts);
            return true;
        }
        return this.showConflicts(conflicts, usages);
    }

    private static MultiMap<PsiElement, String> detectConflicts(UsageInfo[] usages) {
        ArrayList<PsiElement> nonXmlUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> unsupportedUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> unambiguousUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> implicitlyInherited = new ArrayList<PsiElement>();
        for (UsageInfo usage : usages) {
            StyleUsageData usageData;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            if (element.getLanguage() != XMLLanguage.INSTANCE) {
                nonXmlUsages.add(element);
                continue;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            StyleUsageData styleUsageData = usageData = tag != null ? AndroidInlineUtil.getStyleUsageData(tag) : null;
            if (usageData == null) {
                if (usage.getReference() instanceof ResourceNameConverter.MyParentStyleReference) {
                    implicitlyInherited.add(element);
                    continue;
                }
                unsupportedUsages.add(element);
                continue;
            }
            if (usageData.getReference().computeTargetElements().length <= 1) continue;
            unambiguousUsages.add(element);
        }
        return AndroidInlineUtil.buildConflicts(nonXmlUsages, unambiguousUsages, unsupportedUsages, implicitlyInherited);
    }

    protected String getCommandName() {
        return AndroidBundle.message("android.inline.style.command.name", this.myStyleName);
    }

    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = UndoConfirmationPolicy.REQUEST_CONFIRMATION;
        if (undoConfirmationPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidInlineAllStyleUsagesProcessor", "getUndoConfirmationPolicy"));
        }
        return undoConfirmationPolicy;
    }
}

