/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.annotations.NonNull;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.android.tools.idea.stats.LegacySdkStatsService;
import com.intellij.internal.statistic.connect.StatisticsConnectionService;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidStatisticsService
implements StatisticsService {
    @NonNull
    public Notification createNotification(@NotNull String groupDisplayId, @Nullable NotificationListener listener) {
        if (groupDisplayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/android/tools/idea/stats/AndroidStatisticsService", "createNotification"));
        }
        String fullProductName = ApplicationNamesInfo.getInstance().getFullProductName();
        String companyName = ApplicationInfo.getInstance().getCompanyName();
        String text = "<html>Please click <a href='allow'>I agree</a> if you want to help make " + fullProductName + " better or <a href='decline'>I don't agree</a> otherwise. <a href='settings'>more...</a></html>";
        String title = "Help improve " + fullProductName + " by sending usage statistics to " + companyName;
        return new Notification(groupDisplayId, title, text, NotificationType.INFORMATION, listener);
    }

    @Nullable
    public Map<String, String> getStatisticsConfigurationLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        String fullProductName = ApplicationNamesInfo.getInstance().getFullProductName();
        String companyName = ApplicationInfo.getInstance().getCompanyName();
        labels.put("title", "Help improve " + fullProductName + " by sending usage statistics to " + companyName);
        labels.put("allow-checkbox", "Send usage statistics to " + companyName);
        labels.put("details", "<html>This allows " + companyName + " to collect usage information, such as data about your feature usage," + "<br>resource usage and plugin configuration.</html>");
        labels.put("linkUrl", "http://www.google.com/policies/privacy/");
        labels.put("linkBeforeText", "This data is collected in accordance with " + companyName + "'s ");
        labels.put("linkText", "privacy policy");
        labels.put("linkAfterText", ".");
        return labels;
    }

    public StatisticsResult send() {
        if (!AndroidStudioSpecificInitializer.isAndroidStudio()) {
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, "OK");
        }
        StatisticsResult code = AndroidStatisticsService.areStatisticsAuthorized();
        if (code.getCode() != StatisticsResult.ResultCode.SEND) {
            return code;
        }
        LegacySdkStatsService sdkstats = new LegacySdkStatsService();
        try {
            Method getStrictVersion = ApplicationInfo.class.getMethod("getStrictVersion", new Class[0]);
            Object version = getStrictVersion.invoke((Object)ApplicationInfo.getInstance(), new Object[0]);
            sdkstats.ping("studio", (String)version);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return new StatisticsResult(StatisticsResult.ResultCode.SEND, "OK");
    }

    static StatisticsResult areStatisticsAuthorized() {
        StatisticsConnectionService service = new StatisticsConnectionService();
        String serviceUrl = service.getServiceUrl();
        if (serviceUrl == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR");
        }
        if (!service.isTransmissionPermitted()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
        }
        return new StatisticsResult(StatisticsResult.ResultCode.SEND, "OK");
    }
}

