/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.updater;

import com.android.annotations.NonNull;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.io.IFileOp;
import com.android.utils.ILogger;
import java.io.File;
import java.util.Map;
import java.util.Properties;

public class SettingsController {
    public static final String KEY_HTTP_PROXY_PORT = "http.proxyPort";
    public static final String KEY_HTTP_PROXY_HOST = "http.proxyHost";
    public static final String KEY_FORCE_HTTP = "sdkman.force.http";
    public static final String KEY_SHOW_UPDATE_ONLY = "sdkman.show.update.only";
    public static final String KEY_ASK_ADB_RESTART = "sdkman.ask.adb.restart";
    public static final String KEY_USE_DOWNLOAD_CACHE = "sdkman.use.dl.cache";
    private static final String SETTINGS_FILENAME = "androidtool.cfg";
    private final IFileOp mFileOp;
    private final ILogger mSdkLog;
    private final Settings mSettings;

    public SettingsController(@NonNull ILogger sdkLog) {
        this((IFileOp)new FileOp(), sdkLog);
    }

    public SettingsController(@NonNull IFileOp fileOp, @NonNull ILogger sdkLog) {
        this(fileOp, sdkLog, new Settings());
    }

    protected SettingsController(@NonNull IFileOp fileOp, @NonNull ILogger sdkLog, @NonNull Settings settings) {
        this.mFileOp = fileOp;
        this.mSdkLog = sdkLog;
        this.mSettings = settings;
    }

    @NonNull
    public Settings getSettings() {
        return this.mSettings;
    }

    public void setShowUpdateOnly(boolean enabled) {
        this.setSetting(KEY_SHOW_UPDATE_ONLY, enabled);
    }

    void setSetting(@NonNull String key, boolean value) {
        this.mSettings.mProperties.setProperty(key, Boolean.toString(value));
    }

    public void loadSettings() {
        block2: {
            String path = null;
            try {
                String folder = AndroidLocation.getFolder();
                File f = new File(folder, SETTINGS_FILENAME);
                path = f.getPath();
                Properties props = this.mFileOp.loadProperties(f);
                this.mSettings.mProperties.clear();
                this.mSettings.mProperties.putAll((Map<?, ?>)props);
                this.setShowUpdateOnly(this.mSettings.getShowUpdateOnly());
                this.setSetting(KEY_ASK_ADB_RESTART, this.mSettings.getAskBeforeAdbRestart());
                this.setSetting(KEY_USE_DOWNLOAD_CACHE, this.mSettings.getUseDownloadCache());
            }
            catch (Exception e) {
                if (this.mSdkLog == null) break block2;
                this.mSdkLog.error((Throwable)e, "Failed to load settings from .android folder. Path is '%1$s'.", new Object[]{path});
            }
        }
    }

    public void applySettings() {
        Properties props = System.getProperties();
        String proxyHost = this.mSettings.mProperties.getProperty(KEY_HTTP_PROXY_HOST, "");
        String proxyPort = this.mSettings.mProperties.getProperty(KEY_HTTP_PROXY_PORT, "");
        String JAVA_PROP_HTTP_PROXY_HOST = KEY_HTTP_PROXY_HOST;
        String JAVA_PROP_HTTP_PROXY_PORT = KEY_HTTP_PROXY_PORT;
        String JAVA_PROP_HTTPS_PROXY_HOST = "https.proxyHost";
        String JAVA_PROP_HTTPS_PROXY_PORT = "https.proxyPort";
        if (proxyHost != null && proxyHost.length() > 0) {
            props.setProperty(KEY_HTTP_PROXY_HOST, proxyHost);
            props.setProperty("https.proxyHost", proxyHost);
        }
        if (proxyPort != null && proxyPort.length() > 0) {
            props.setProperty(KEY_HTTP_PROXY_PORT, proxyPort);
            props.setProperty("https.proxyPort", proxyPort);
        }
    }

    public static class Settings {
        private final Properties mProperties;

        public Settings() {
            this.mProperties = new Properties();
        }

        public Settings(@NonNull Settings settings) {
            this();
            for (Map.Entry<Object, Object> entry : settings.mProperties.entrySet()) {
                this.mProperties.put(entry.getKey(), entry.getValue());
            }
        }

        protected Settings(@NonNull Properties properties) {
            this.mProperties = properties;
        }

        public boolean getForceHttp() {
            return Boolean.parseBoolean(this.mProperties.getProperty(SettingsController.KEY_FORCE_HTTP));
        }

        public boolean getAskBeforeAdbRestart() {
            return Boolean.parseBoolean(this.mProperties.getProperty(SettingsController.KEY_ASK_ADB_RESTART));
        }

        public boolean getUseDownloadCache() {
            return Boolean.parseBoolean(this.mProperties.getProperty(SettingsController.KEY_USE_DOWNLOAD_CACHE, Boolean.TRUE.toString()));
        }

        public boolean getShowUpdateOnly() {
            return Boolean.parseBoolean(this.mProperties.getProperty(SettingsController.KEY_SHOW_UPDATE_ONLY, Boolean.TRUE.toString()));
        }
    }
}

