/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.tools.idea.monitor.DeviceSampler;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class BaseMonitorView
implements HierarchyListener {
    @NotNull
    protected Project myProject;
    @NotNull
    protected JPanel myContentPane;

    protected BaseMonitorView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/BaseMonitorView", "<init>"));
        }
        this.myProject = project;
        this.myContentPane = new JPanel(new BorderLayout());
        this.myContentPane.addHierarchyListener(this);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && !this.getSampler().isRunning()) {
            this.getSampler().start();
        }
    }

    protected abstract DeviceSampler getSampler();

    protected boolean isShowing() {
        return this.myContentPane.isShowing();
    }

    protected void setComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/monitor/BaseMonitorView", "setComponent"));
        }
        this.myContentPane.add((Component)component, "Center");
    }
}

