/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class InstallPlatformHyperlink
extends NotificationHyperlink {
    @NotNull
    private final AndroidVersion[] myAndroidVersions;

    public InstallPlatformHyperlink(AndroidVersion ... androidVersions) {
        if (androidVersions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidVersions", "com/android/tools/idea/gradle/service/notification/hyperlink/InstallPlatformHyperlink", "<init>"));
        }
        super("install.android.platform", "Install missing platform(s) and sync project");
        this.myAndroidVersions = androidVersions;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/InstallPlatformHyperlink", "execute"));
        }
        ArrayList requested = Lists.newArrayList();
        for (AndroidVersion version : this.myAndroidVersions) {
            requested.add(PkgDesc.Builder.newPlatform((AndroidVersion)version, (MajorRevision)new MajorRevision(1), (FullRevision)FullRevision.NOT_SPECIFIED).create());
        }
        SdkQuickfixWizard wizard = new SdkQuickfixWizard(project, null, requested);
        wizard.init();
        if (wizard.showAndGet()) {
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }
}

