/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.parser;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.editor.entity.ExternalDependencyGradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntityGroup;
import com.android.tools.idea.gradle.editor.entity.GradleEditorRepositoryEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.entity.VersionGradleEditorEntity;
import com.android.tools.idea.gradle.editor.metadata.GradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.metadata.StdGradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.parser.GradleEditorDependencyParser;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelCustomizer;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParseContext;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParser;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelUtil;
import com.android.tools.idea.gradle.editor.value.BuildToolsValueManager;
import com.android.tools.idea.gradle.editor.value.GradleEditorEntityValueManager;
import com.android.tools.idea.gradle.editor.value.LibraryVersionsManager;
import com.android.tools.idea.gradle.editor.value.SdkValueManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleEditorModelParserV1
implements GradleEditorModelParser {
    private static final Logger LOG = Logger.getInstance(GradleEditorModelParserV1.class);
    private static final List<String> PROJECT_QUALIFIER = Collections.emptyList();

    @Override
    @NotNull
    public GradleCoordinate getMinSupportedAndroidGradlePluginVersion() {
        GradleCoordinate gradleCoordinate = GradleCoordinate.parseVersionOnly((String)"0");
        if (gradleCoordinate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "getMinSupportedAndroidGradlePluginVersion"));
        }
        return gradleCoordinate;
    }

    @Override
    @NotNull
    public GradleCoordinate getMaxSupportedAndroidGradlePluginVersion() {
        GradleCoordinate gradleCoordinate = GradleCoordinate.parseVersionOnly((String)"100");
        if (gradleCoordinate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "getMaxSupportedAndroidGradlePluginVersion"));
        }
        return gradleCoordinate;
    }

    @Override
    @NotNull
    public List<GradleEditorEntityGroup> buildEntities(@NotNull GradleEditorModelParseContext context) {
        GradleEditorEntityGroup repositories;
        GradleEditorEntityGroup dependencies;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildEntities"));
        }
        List<Object> result = Lists.newArrayList();
        GradleEditorEntityGroup buildConfiguration = this.buildConfiguration(context);
        if (buildConfiguration != null) {
            result.add(buildConfiguration);
        }
        if ((dependencies = this.dependencies(context)) != null) {
            result.add(dependencies);
        }
        if ((repositories = this.repositories(context)) != null) {
            result.add(repositories);
        }
        for (GradleEditorModelCustomizer customizer : (GradleEditorModelCustomizer[])GradleEditorModelCustomizer.EP_NAME.getExtensions()) {
            result = customizer.postProcess(result, context);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildEntities"));
        }
        return arrayList;
    }

    @Nullable
    protected static GradleEditorEntityGroup combine(@NotNull String sectionText, GradleEditorEntity ... childEntities) {
        if (sectionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sectionText", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "combine"));
        }
        if (childEntities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childEntities", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "combine"));
        }
        GradleEditorEntityGroup result = null;
        for (GradleEditorEntity childEntity : childEntities) {
            if (childEntity == null) continue;
            if (result == null) {
                result = new GradleEditorEntityGroup(sectionText);
            }
            result.addEntity(childEntity);
        }
        return result;
    }

    @Nullable
    protected GradleEditorEntityGroup buildConfiguration(@NotNull GradleEditorModelParseContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildConfiguration"));
        }
        return GradleEditorModelParserV1.combine(AndroidBundle.message("android.gradle.editor.header.build", new Object[0]), GradleEditorModelParserV1.buildGradlePluginVersion(context), this.buildCompileSdkVersion(context), this.buildBuildSdkVersion(context));
    }

    @Nullable
    public static VersionGradleEditorEntity buildGradlePluginVersion(@NotNull GradleEditorModelParseContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildGradlePluginVersion"));
        }
        GradleEditorModelParseContext.Variable variable = new GradleEditorModelParseContext.Variable("classpath", PROJECT_QUALIFIER);
        GradleEditorDependencyParser dependencyParser = new GradleEditorDependencyParser();
        for (GradleEditorModelParseContext.Assignment assignment : context.getAssignments(variable)) {
            GradleEditorEntity entity = dependencyParser.parse(assignment, context);
            if (!(entity instanceof ExternalDependencyGradleEditorEntity)) continue;
            ExternalDependencyGradleEditorEntity e = (ExternalDependencyGradleEditorEntity)entity;
            int i = "com.android.tools.build:gradle:".indexOf(58);
            String groupId = "com.android.tools.build:gradle:".substring(0, i);
            String artifactId = "com.android.tools.build:gradle:".substring(i + 1);
            if (artifactId.endsWith(":")) {
                artifactId = artifactId.substring(0, artifactId.length() - 1);
            }
            if (!groupId.equals(e.getGroupId()) || !artifactId.equals(e.getArtifactId())) continue;
            HashSet metaData = Sets.newHashSet(e.getMetaData());
            if (!e.getMetaData().contains(StdGradleEditorEntityMetaData.INJECTED)) {
                metaData.add(StdGradleEditorEntityMetaData.OUTGOING);
            }
            metaData.remove(StdGradleEditorEntityMetaData.REMOVABLE);
            return new VersionGradleEditorEntity(AndroidBundle.message("android.gradle.editor.version.gradle.plugin", new Object[0]), e.getVersionSourceBindings(), e.getEntityLocation(), metaData, e.getDeclarationValueLocation(), e.getVersion(), (GradleEditorEntityValueManager)new LibraryVersionsManager(groupId, artifactId), "http://tools.android.com/tech-docs/new-build-system/user-guide#TOC-Simple-build-files");
        }
        return null;
    }

    @Nullable
    protected GradleEditorEntity buildCompileSdkVersion(@NotNull GradleEditorModelParseContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildCompileSdkVersion"));
        }
        SimpleEntityData entityData = GradleEditorModelParserV1.buildSimpleEntityData(new GradleEditorModelParseContext.Variable("compileSdkVersion", PROJECT_QUALIFIER), context, null);
        if (entityData == null) {
            return null;
        }
        return new VersionGradleEditorEntity(AndroidBundle.message("android.gradle.editor.version.sdk.compile", new Object[0]), entityData.definitionValueSourceBindings, entityData.wholeEntityLocation, entityData.metaData, entityData.declarationValueLocation, entityData.value, (GradleEditorEntityValueManager)new SdkValueManager(), null);
    }

    @Nullable
    protected GradleEditorEntity buildBuildSdkVersion(@NotNull GradleEditorModelParseContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildBuildSdkVersion"));
        }
        SimpleEntityData entityData = GradleEditorModelParserV1.buildSimpleEntityData(new GradleEditorModelParseContext.Variable("buildToolsVersion", PROJECT_QUALIFIER), context, null);
        if (entityData == null) {
            return null;
        }
        return new VersionGradleEditorEntity(AndroidBundle.message("android.gradle.editor.version.build.tools", new Object[0]), entityData.definitionValueSourceBindings, entityData.wholeEntityLocation, entityData.metaData, entityData.declarationValueLocation, entityData.value, (GradleEditorEntityValueManager)new BuildToolsValueManager(), null);
    }

    @Nullable
    protected static SimpleEntityData buildSimpleEntityData(@NotNull GradleEditorModelParseContext.Variable lValue, @NotNull GradleEditorModelParseContext context, @Nullable GradleEditorModelUtil.AssignmentFilter assignmentFilter) {
        if (lValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lValue", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildSimpleEntityData"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildSimpleEntityData"));
        }
        GradleEditorModelParseContext.Assignment targetAssignment = null;
        for (GradleEditorModelParseContext.Assignment assignment : context.getAssignments(lValue)) {
            GradleEditorModelParseContext.Assignment assignmentToUse = assignmentFilter == null ? assignment : assignmentFilter.check(assignment);
            if (assignmentToUse == null) continue;
            if (targetAssignment == null) {
                targetAssignment = assignmentToUse;
                continue;
            }
            LOG.warn(String.format("More than one assignment for the same l-value (%s) is found at the target file (%s): '%s' and '%s',", lValue, context.getTargetFile().getPath(), targetAssignment, assignmentToUse));
            return null;
        }
        if (targetAssignment == null) {
            return null;
        }
        GradleEditorSourceBinding declarationValueLocation = GradleEditorModelUtil.buildSourceBinding(targetAssignment.rValueLocation, context.getProject());
        if (declarationValueLocation == null) {
            return null;
        }
        GradleEditorSourceBinding wholeEntityLocation = GradleEditorModelUtil.buildSourceBinding(targetAssignment, context.getProject());
        if (wholeEntityLocation == null) {
            return null;
        }
        GradleEditorModelUtil.EntityInfo entityInfo = GradleEditorModelUtil.collectInfo(Collections.singleton(lValue), context, assignmentFilter);
        if (entityInfo.sourceBindings.isEmpty()) {
            return null;
        }
        Set<GradleEditorEntityMetaData> metaData = GradleEditorModelParserV1.buildMetaData(targetAssignment, context);
        return new SimpleEntityData(entityInfo.sourceBindings, metaData, entityInfo.value, wholeEntityLocation, declarationValueLocation);
    }

    @Nullable
    protected static SimpleEntityData buildSimpleEntityData(@NotNull GradleEditorModelParseContext.Assignment assignment, @NotNull GradleEditorModelParseContext context) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildSimpleEntityData"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildSimpleEntityData"));
        }
        GradleEditorSourceBinding declarationValueLocation = GradleEditorModelUtil.buildSourceBinding(assignment.rValueLocation, context.getProject());
        if (declarationValueLocation == null) {
            return null;
        }
        GradleEditorSourceBinding wholeEntityLocation = GradleEditorModelUtil.buildSourceBinding(assignment, context.getProject());
        if (wholeEntityLocation == null) {
            return null;
        }
        Set<GradleEditorEntityMetaData> metaData = GradleEditorModelParserV1.buildMetaData(assignment, context);
        if (assignment.dependencies.isEmpty()) {
            return new SimpleEntityData(Collections.singleton(declarationValueLocation), metaData, assignment.value == null ? "" : assignment.value.value, wholeEntityLocation, declarationValueLocation);
        }
        GradleEditorModelUtil.EntityInfo info = GradleEditorModelUtil.collectInfo(assignment.dependencies.asMap().keySet(), context, null);
        ArrayList definitionValueSourceBindings = Lists.newArrayList(info.sourceBindings);
        if (assignment.value != null && assignment.value.value.isEmpty()) {
            definitionValueSourceBindings.add(declarationValueLocation);
        }
        String valueToUse = assignment.value == null ? info.value : assignment.value.value;
        return new SimpleEntityData(definitionValueSourceBindings, metaData, valueToUse, wholeEntityLocation, declarationValueLocation);
    }

    @NotNull
    protected static Set<GradleEditorEntityMetaData> buildMetaData(@NotNull GradleEditorModelParseContext.Assignment assignment, @NotNull GradleEditorModelParseContext context) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildMetaData"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildMetaData"));
        }
        HashSet result = Sets.newHashSet();
        if (context.getTargetFile().equals(assignment.lValueLocation.file)) {
            String topSection;
            if (!assignment.codeStructure.isEmpty() && ("allprojects".equals(topSection = assignment.codeStructure.get(0)) || "subprojects".equals(topSection))) {
                result.add(StdGradleEditorEntityMetaData.OUTGOING);
            }
        } else {
            result.add(StdGradleEditorEntityMetaData.INJECTED);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "buildMetaData"));
        }
        return hashSet;
    }

    @Nullable
    protected GradleEditorEntityGroup dependencies(@NotNull GradleEditorModelParseContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "dependencies"));
        }
        ArrayList dependencies = Lists.newArrayList();
        GradleEditorDependencyParser dependencyParser = new GradleEditorDependencyParser();
        Collection<GradleEditorModelParseContext.Assignment> currentDependencies = context.getAssignments(Collections.singletonList("dependencies"));
        Collection<GradleEditorModelParseContext.Assignment> subProjectDependencies = context.getAssignments(Lists.newArrayList((Object[])new String[]{"subprojects", "dependencies"}));
        Collection<GradleEditorModelParseContext.Assignment> allProjectDependencies = context.getAssignments(Lists.newArrayList((Object[])new String[]{"allprojects", "dependencies"}));
        for (GradleEditorModelParseContext.Assignment assignment : Iterables.concat(currentDependencies, subProjectDependencies, allProjectDependencies)) {
            GradleEditorEntity entity = dependencyParser.parse(assignment, context);
            if (entity == null) continue;
            dependencies.add(entity);
        }
        if (dependencies.isEmpty()) {
            return null;
        }
        String headerText = AndroidBundle.message("android.gradle.editor.header.dependencies", new Object[0]);
        return GradleEditorModelParserV1.combine(headerText, (GradleEditorEntity[])Iterables.toArray((Iterable)dependencies, GradleEditorEntity.class));
    }

    @Nullable
    protected GradleEditorEntityGroup repositories(@NotNull GradleEditorModelParseContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1", "repositories"));
        }
        ArrayList repositories = Lists.newArrayList();
        ArrayList requestKeys = Lists.newArrayList();
        requestKeys.add(Arrays.asList("buildscript", "repositories"));
        requestKeys.add(Arrays.asList("buildscript", "repositories", "maven"));
        requestKeys.add(Arrays.asList("subprojects", "repositories"));
        requestKeys.add(Arrays.asList("subprojects", "repositories", "maven"));
        requestKeys.add(Arrays.asList("allprojects", "repositories"));
        requestKeys.add(Arrays.asList("allprojects", "repositories", "maven"));
        ArrayList assignments = Lists.newArrayList();
        for (List key : requestKeys) {
            assignments.addAll(context.getAssignments(key));
        }
        for (GradleEditorModelParseContext.Assignment assignment : assignments) {
            SimpleEntityData data;
            String topSection;
            if (assignment.value == null || !context.getTargetFile().equals(assignment.lValueLocation.file) && !assignment.codeStructure.isEmpty() && !"allprojects".equals(topSection = assignment.codeStructure.get(0)) && !"subprojects".equals(topSection)) continue;
            if ("()".equals(assignment.value.value)) {
                String name = null;
                String value = null;
                String helpId = null;
                if ("mavenCentral".equals(assignment.lValue.name)) {
                    name = AndroidBundle.message("android.gradle.editor.header.repository.maven", new Object[0]);
                    value = "http://central.maven.org/maven2";
                    helpId = "http://gradle.org/docs/current/userguide/userguide_single.html#sub:maven_central";
                } else if ("jcenter".equals(assignment.lValue.name)) {
                    name = AndroidBundle.message("android.gradle.editor.header.repository.jcenter", new Object[0]);
                    value = "https://jcenter.bintray.com";
                    helpId = "http://gradle.org/docs/current/userguide/userguide_single.html#mavenJcenter";
                }
                if (name == null) continue;
                Set<GradleEditorEntityMetaData> metaData = GradleEditorModelParserV1.buildMetaData(assignment, context);
                metaData.add(StdGradleEditorEntityMetaData.READ_ONLY);
                GradleEditorSourceBinding sourceBinding = GradleEditorModelUtil.buildSourceBinding(assignment, context.getProject());
                if (sourceBinding == null) continue;
                repositories.add(new GradleEditorRepositoryEntity(name, value, Collections.<GradleEditorSourceBinding>emptyList(), sourceBinding, metaData, sourceBinding, helpId));
                continue;
            }
            if (!"url".equals(assignment.lValue.name) || (data = GradleEditorModelParserV1.buildSimpleEntityData(assignment, context)) == null) continue;
            repositories.add(new GradleEditorRepositoryEntity(AndroidBundle.message("android.gradle.editor.header.repository.third.party", new Object[0]), data.value, data.definitionValueSourceBindings, data.wholeEntityLocation, data.metaData, data.declarationValueLocation, "http://gradle.org/docs/current/userguide/userguide_single.html#sub:maven_repo"));
        }
        if (repositories.isEmpty()) {
            return null;
        }
        String headerText = AndroidBundle.message("android.gradle.editor.header.repositories", new Object[0]);
        return GradleEditorModelParserV1.combine(headerText, (GradleEditorEntity[])Iterables.toArray((Iterable)repositories, GradleEditorEntity.class));
    }

    private static class SimpleEntityData {
        @NotNull
        final Collection<GradleEditorSourceBinding> definitionValueSourceBindings;
        @NotNull
        final Set<GradleEditorEntityMetaData> metaData;
        @NotNull
        final String value;
        @NotNull
        final GradleEditorSourceBinding wholeEntityLocation;
        @NotNull
        final GradleEditorSourceBinding declarationValueLocation;

        SimpleEntityData(@NotNull Collection<GradleEditorSourceBinding> definitionValueSourceBindings, @NotNull Set<GradleEditorEntityMetaData> metaData, @NotNull String value, @NotNull GradleEditorSourceBinding wholeEntityLocation, @NotNull GradleEditorSourceBinding declarationValueLocation) {
            if (definitionValueSourceBindings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionValueSourceBindings", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1$SimpleEntityData", "<init>"));
            }
            if (metaData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1$SimpleEntityData", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1$SimpleEntityData", "<init>"));
            }
            if (wholeEntityLocation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wholeEntityLocation", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1$SimpleEntityData", "<init>"));
            }
            if (declarationValueLocation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationValueLocation", "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1$SimpleEntityData", "<init>"));
            }
            this.definitionValueSourceBindings = definitionValueSourceBindings;
            this.metaData = metaData;
            this.value = value;
            this.wholeEntityLocation = wholeEntityLocation;
            this.declarationValueLocation = declarationValueLocation;
        }
    }
}

