/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.IndexedValue;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBuf;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmNameResolver
implements NameResolver {
    private final Set<Integer> localNameIndices;
    private final List<JvmProtoBuf.StringTableTypes.Record> records;
    private final JvmProtoBuf.StringTableTypes types;
    private final String[] strings;
    @NotNull
    public static final List<String> PREDEFINED_STRINGS;
    private static final Map<String, Integer> PREDEFINED_STRINGS_MAP;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getString(int index) {
        Object object;
        Integer end;
        Integer begin;
        Object object2;
        List<Integer> $receiver$iv;
        List<Integer> list;
        String string;
        JvmProtoBuf.StringTableTypes.Record record = this.records.get(index);
        String string2 = record.hasString() ? record.getString() : (string = record.hasPredefinedIndex() && CollectionsKt.getIndices((Collection)Companion.getPREDEFINED_STRINGS()).contains(record.getPredefinedIndex()) ? Companion.getPREDEFINED_STRINGS().get(record.getPredefinedIndex()) : this.strings[index]);
        if (record.getSubstringIndexCount() >= 2) {
            List<Integer> list2 = list = record.getSubstringIndexList();
            object2 = (Integer)$receiver$iv.get(0);
            $receiver$iv = list;
            Integer n = $receiver$iv.get(1);
            list = null;
            if (Intrinsics.compare(0, ((Number)begin).intValue()) <= 0 && Intrinsics.compare(((Number)begin).intValue(), ((Number)end).intValue()) <= 0 && Intrinsics.compare(((Number)end).intValue(), CollectionsKt.length(string)) <= 0) {
                string = StringsKt.substring(string, ((Number)begin).intValue(), ((Number)end).intValue());
            }
        }
        if (record.getReplaceCharCount() >= 2) {
            void to;
            void from;
            $receiver$iv = list = record.getReplaceCharList();
            begin = $receiver$iv.get(0);
            $receiver$iv = list;
            end = $receiver$iv.get(1);
            list = null;
            string = StringsKt.replace$default(string, (char)((Number)from).intValue(), (char)((Number)to).intValue(), false, 4);
        }
        if ((object = record.getOperation()) == null) {
            object = object2 = JvmProtoBuf.StringTableTypes.Record.Operation.NONE;
        }
        if (!Intrinsics.areEqual(object2, JvmProtoBuf.StringTableTypes.Record.Operation.NONE)) {
            if (Intrinsics.areEqual(object2, JvmProtoBuf.StringTableTypes.Record.Operation.INTERNAL_TO_CLASS_ID)) {
                string = StringsKt.replace$default(string, '$', '.', false, 4);
            } else if (Intrinsics.areEqual(object2, JvmProtoBuf.StringTableTypes.Record.Operation.DESC_TO_CLASS_ID)) {
                if (CollectionsKt.length(string) >= 2) {
                    string = StringsKt.substring(string, 1, CollectionsKt.length(string) - 1);
                }
                string = StringsKt.replace$default(string, '$', '.', false, 4);
            }
        }
        String string3 = string;
        Intrinsics.checkExpressionValueIsNotNull(string3, "string");
        return string3;
    }

    @Override
    @NotNull
    public Name getName(int index) {
        return Name.guess(this.getString(index));
    }

    @Override
    @NotNull
    public ClassId getClassId(int index) {
        String string = this.getString(index);
        int lastSlash = StringsKt.lastIndexOf$default((CharSequence)string, '/', 0, false, 6);
        FqName packageName = lastSlash < 0 ? FqName.ROOT : new FqName(StringsKt.replace$default(StringsKt.substring(string, 0, lastSlash), '/', '.', false, 4));
        FqName className = new FqName(StringsKt.substring(string, lastSlash + 1));
        return new ClassId(packageName, className, this.localNameIndices.contains(index));
    }

    /*
     * WARNING - void declaration
     */
    public JvmNameResolver(@NotNull JvmProtoBuf.StringTableTypes types, @NotNull String[] strings) {
        void $receiver$iv;
        ArrayList<JvmProtoBuf.StringTableTypes.Record> $receiver$iv2;
        Intrinsics.checkParameterIsNotNull(types, "types");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        this.types = types;
        this.strings = strings;
        List<Integer> list = this.types.getLocalNameList();
        JvmNameResolver jvmNameResolver = this;
        ArrayList<JvmProtoBuf.StringTableTypes.Record> $receiver = $receiver$iv2;
        Collection<Object> collection = $receiver.isEmpty() ? SetsKt.emptySet() : CollectionsKt.toSet((Iterable)$receiver);
        jvmNameResolver.localNameIndices = collection;
        $receiver$iv2 = new ArrayList<JvmProtoBuf.StringTableTypes.Record>();
        jvmNameResolver = this;
        $receiver = $receiver$iv2;
        List<JvmProtoBuf.StringTableTypes.Record> records = this.types.getRecordList();
        Collection $i$f$run = records;
        ArrayList<JvmProtoBuf.StringTableTypes.Record> arrayList = $receiver;
        int n = $receiver$iv.size();
        arrayList.ensureCapacity(n);
        block0: for (JvmProtoBuf.StringTableTypes.Record record : records) {
            void times$iv;
            int n2 = record.getRange();
            boolean bl = false;
            void var14_14 = times$iv - true;
            if (bl > var14_14) continue;
            while (true) {
                void index$iv;
                void it = ++index$iv;
                $receiver.add(record);
                if (index$iv == var14_14) continue block0;
            }
        }
        $receiver.trimToSize();
        collection = list;
        jvmNameResolver.records = (List)collection;
    }

    static {
        Companion = kotlin.reflect.jvm.internal.impl.load.kotlin.JvmNameResolver$Companion.INSTANCE;
        PREDEFINED_STRINGS = CollectionsKt.listOf("kotlin/Any", "kotlin/Nothing", "kotlin/Unit", "kotlin/Throwable", "kotlin/Number", "kotlin/Byte", "kotlin/Double", "kotlin/Float", "kotlin/Int", "kotlin/Long", "kotlin/Short", "kotlin/Boolean", "kotlin/Char", "kotlin/CharSequence", "kotlin/String", "kotlin/Comparable", "kotlin/Enum", "kotlin/Array", "kotlin/ByteArray", "kotlin/DoubleArray", "kotlin/FloatArray", "kotlin/IntArray", "kotlin/LongArray", "kotlin/ShortArray", "kotlin/BooleanArray", "kotlin/CharArray", "kotlin/Cloneable", "kotlin/Annotation", "kotlin/Iterable", "kotlin/MutableIterable", "kotlin/Collection", "kotlin/MutableCollection", "kotlin/List", "kotlin/MutableList", "kotlin/Set", "kotlin/MutableSet", "kotlin/Map", "kotlin/MutableMap", "kotlin/Map.Entry", "kotlin/MutableMap.MutableEntry", "kotlin/Iterator", "kotlin/MutableIterator", "kotlin/ListIterator", "kotlin/MutableListIterator");
        Iterable $receiver$iv = CollectionsKt.withIndex((Iterable)Companion.getPREDEFINED_STRINGS());
        Iterable $receiver$iv$iv = $receiver$iv;
        float capacity$iv$iv = (float)CollectionsKt.collectionSizeOrDefault($receiver$iv$iv, 10) / 0.75f + 1.0f;
        LinkedHashMap<String, Integer> result$iv$iv = new LinkedHashMap<String, Integer>(Math.max((int)capacity$iv$iv, 16));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IndexedValue it;
            IndexedValue element$iv$iv;
            IndexedValue indexedValue = element$iv$iv = iterator2.next();
            LinkedHashMap<String, Integer> linkedHashMap = result$iv$iv;
            String string = (String)it.getValue();
            it = element$iv$iv;
            Integer n = it.getIndex();
            linkedHashMap.put(string, n);
        }
        PREDEFINED_STRINGS_MAP = result$iv$iv;
    }

    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final List<String> getPREDEFINED_STRINGS() {
            return PREDEFINED_STRINGS;
        }

        private final Map<String, Integer> getPREDEFINED_STRINGS_MAP() {
            return PREDEFINED_STRINGS_MAP;
        }

        @Nullable
        public final Integer getPredefinedStringIndex(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "string");
            return this.getPREDEFINED_STRINGS_MAP().get(string);
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

