/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jetbrains.plugins.javaFX.packaging.AbstractJavaFxPackager;
import org.jetbrains.plugins.javaFX.packaging.JavaFxManifestAttribute;
import org.jetbrains.plugins.javaFX.packaging.JavaFxPackagerConstants;

public class JavaFxAntGenerator {
    public static List<SimpleTag> createJarAndDeployTasks(AbstractJavaFxPackager packager, String artifactFileName, String artifactName, String tempDirPath) {
        String artifactFileNameWithoutExtension = FileUtil.getNameWithoutExtension((String)artifactFileName);
        ArrayList<SimpleTag> topLevelTagsCollector = new ArrayList<SimpleTag>();
        String preloaderJar = packager.getPreloaderJar();
        String preloaderClass = packager.getPreloaderClass();
        String preloaderFiles = null;
        String allButPreloader = null;
        if (!StringUtil.isEmptyOrSpaces((String)preloaderJar) && !StringUtil.isEmptyOrSpaces((String)preloaderClass)) {
            preloaderFiles = artifactFileNameWithoutExtension + "_preloader_files";
            topLevelTagsCollector.add(new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"id", (Object)preloaderFiles), Couple.of((Object)"requiredFor", (Object)"preloader"), Couple.of((Object)"dir", (Object)tempDirPath), Couple.of((Object)"includes", (Object)preloaderJar)}));
            allButPreloader = "all_but_preloader_" + artifactFileNameWithoutExtension;
            topLevelTagsCollector.add(new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"id", (Object)allButPreloader), Couple.of((Object)"dir", (Object)tempDirPath), Couple.of((Object)"excludes", (Object)preloaderJar), Couple.of((Object)"includes", (Object)"**/*.jar")}));
        }
        String allButSelf = "all_but_" + artifactFileNameWithoutExtension;
        SimpleTag allButSelfAndPreloader = new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"id", (Object)allButSelf), Couple.of((Object)"dir", (Object)tempDirPath), Couple.of((Object)"includes", (Object)"**/*.jar")});
        allButSelfAndPreloader.add(new SimpleTag("exclude", new Pair[]{Couple.of((Object)"name", (Object)artifactFileName)}));
        if (preloaderJar != null) {
            allButSelfAndPreloader.add(new SimpleTag("exclude", new Pair[]{Couple.of((Object)"name", (Object)preloaderJar)}));
        }
        topLevelTagsCollector.add(allButSelfAndPreloader);
        String all = "all_" + artifactFileNameWithoutExtension;
        SimpleTag allIncluded = new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"id", (Object)all), Couple.of((Object)"dir", (Object)tempDirPath), Couple.of((Object)"includes", (Object)"**/*.jar")});
        topLevelTagsCollector.add(allIncluded);
        String appId = artifactFileNameWithoutExtension + "_id";
        SimpleTag applicationTag = new SimpleTag("fx:application", new Pair[]{Couple.of((Object)"id", (Object)appId), Couple.of((Object)"name", (Object)artifactName), Couple.of((Object)"mainClass", (Object)packager.getAppClass())});
        if (preloaderFiles != null) {
            applicationTag.addAttribute((Pair)Couple.of((Object)"preloaderClass", (Object)preloaderClass));
        }
        JavaFxAntGenerator.appendValuesFromPropertiesFile(applicationTag, packager.getHtmlParamFile(), "fx:htmlParam", false);
        JavaFxAntGenerator.appendValuesFromPropertiesFile(applicationTag, packager.getParamFile(), "fx:param", true);
        topLevelTagsCollector.add(applicationTag);
        if (packager.convertCss2Bin()) {
            SimpleTag css2binTag = new SimpleTag("fx:csstobin", new Pair[]{Couple.of((Object)"outdir", (Object)tempDirPath)});
            css2binTag.add(new SimpleTag("fileset", new Pair[]{Couple.of((Object)"dir", (Object)tempDirPath), Couple.of((Object)"includes", (Object)"**/*.css")}));
            topLevelTagsCollector.add(css2binTag);
        }
        SimpleTag createJarTag = new SimpleTag("fx:jar", new Pair[]{Couple.of((Object)"destfile", (Object)(tempDirPath + File.separator + artifactFileName))});
        createJarTag.add(new SimpleTag("fx:application", new Pair[]{Couple.of((Object)"refid", (Object)appId)}));
        ArrayList<Couple> fileset2Jar = new ArrayList<Couple>();
        fileset2Jar.add(Couple.of((Object)"dir", (Object)tempDirPath));
        fileset2Jar.add(Couple.of((Object)"excludes", (Object)"**/*.jar"));
        createJarTag.add(new SimpleTag("fileset", fileset2Jar.toArray(new Pair[fileset2Jar.size()])));
        createJarTag.add(JavaFxAntGenerator.createResourcesTag(preloaderFiles, false, allButPreloader, allButSelf, all));
        List<JavaFxManifestAttribute> manifestAttributes = packager.getCustomManifestAttributes();
        if (manifestAttributes != null) {
            SimpleTag manifestTag = new SimpleTag("manifest", new Pair[0]);
            for (JavaFxManifestAttribute pair : manifestAttributes) {
                manifestTag.add(new SimpleTag("attribute", new Pair[]{Couple.of((Object)"name", (Object)pair.getName()), Couple.of((Object)"value", (Object)pair.getValue())}));
            }
            createJarTag.add(manifestTag);
        }
        topLevelTagsCollector.add(createJarTag);
        SimpleTag deployTag = new SimpleTag("fx:deploy", new Pair[]{Couple.of((Object)"width", (Object)packager.getWidth()), Couple.of((Object)"height", (Object)packager.getHeight()), Couple.of((Object)"updatemode", (Object)packager.getUpdateMode()), Couple.of((Object)"outdir", (Object)(tempDirPath + File.separator + "deploy")), Couple.of((Object)"outfile", (Object)artifactFileNameWithoutExtension)});
        JavaFxPackagerConstants.NativeBundles bundle = packager.getNativeBundle();
        if (bundle != JavaFxPackagerConstants.NativeBundles.none) {
            deployTag.addAttribute((Pair)Couple.of((Object)"nativeBundles", (Object)bundle.name()));
        }
        if (packager.isEnabledSigning()) {
            deployTag.add(new SimpleTag("fx:permissions", new Pair[]{Couple.of((Object)"elevated", (Object)"true")}));
        }
        deployTag.add(new SimpleTag("fx:application", new Pair[]{Couple.of((Object)"refid", (Object)appId)}));
        ArrayList<Pair> infoPairs = new ArrayList<Pair>();
        JavaFxAntGenerator.appendIfNotEmpty(infoPairs, "title", packager.getTitle());
        JavaFxAntGenerator.appendIfNotEmpty(infoPairs, "vendor", packager.getVendor());
        JavaFxAntGenerator.appendIfNotEmpty(infoPairs, "description", packager.getDescription());
        if (!infoPairs.isEmpty()) {
            deployTag.add(new SimpleTag("fx:info", infoPairs.toArray(new Pair[infoPairs.size()])));
        }
        deployTag.add(JavaFxAntGenerator.createResourcesTag(preloaderFiles, true, allButPreloader, allButSelf, all));
        topLevelTagsCollector.add(deployTag);
        return topLevelTagsCollector;
    }

    private static SimpleTag createResourcesTag(String preloaderFiles, boolean includeSelf, String allButPreloader, String allButSelf, String all) {
        SimpleTag resourcesTag = new SimpleTag("fx:resources", new Pair[0]);
        if (preloaderFiles != null) {
            resourcesTag.add(new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"refid", (Object)preloaderFiles)}));
            resourcesTag.add(new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"refid", (Object)(includeSelf ? allButPreloader : allButSelf))}));
        } else {
            resourcesTag.add(new SimpleTag("fx:fileset", new Pair[]{Couple.of((Object)"refid", (Object)(includeSelf ? all : allButSelf))}));
        }
        return resourcesTag;
    }

    private static void appendIfNotEmpty(List<Pair> pairs, String propertyName, String propValue) {
        if (!StringUtil.isEmptyOrSpaces((String)propValue)) {
            pairs.add((Pair)Couple.of((Object)propertyName, (Object)propValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendValuesFromPropertiesFile(SimpleTag applicationTag, String paramFile, String paramTagName, boolean allowNoNamed) {
        if (!StringUtil.isEmptyOrSpaces((String)paramFile)) {
            Properties properties = new Properties();
            try {
                FileInputStream paramsInputStream = new FileInputStream(new File(paramFile));
                try {
                    properties.load(paramsInputStream);
                    for (Object o : properties.keySet()) {
                        final String propName = (String)o;
                        String propValue = properties.getProperty(propName);
                        if (!StringUtil.isEmptyOrSpaces((String)propValue)) {
                            applicationTag.add(new SimpleTag(paramTagName, new Pair[]{Couple.of((Object)"name", (Object)propName), Couple.of((Object)"value", (Object)propValue)}));
                            continue;
                        }
                        if (!allowNoNamed) continue;
                        applicationTag.add(new SimpleTag("fx:argument", propName){

                            @Override
                            public void generate(StringBuilder buf) {
                                buf.append("<").append(this.getName()).append(">").append(propName).append("</").append(this.getName()).append(">");
                            }
                        });
                    }
                }
                finally {
                    paramsInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class SimpleTag {
        private final String myName;
        private final List<Pair> myPairs;
        private final List<SimpleTag> mySubTags = new ArrayList<SimpleTag>();
        private final String myValue;

        public SimpleTag(String name, Pair ... pairs) {
            this.myName = name;
            this.myPairs = new ArrayList<Pair>(Arrays.asList(pairs));
            this.myValue = null;
        }

        public SimpleTag(String name, String value) {
            this.myName = name;
            this.myPairs = new ArrayList<Pair>();
            this.myValue = value;
        }

        public void addAttribute(Pair attr) {
            this.myPairs.add(attr);
        }

        public void add(SimpleTag tag) {
            this.mySubTags.add(tag);
        }

        public String getName() {
            return this.myName;
        }

        public Pair[] getPairs() {
            return this.myPairs.toArray(new Pair[this.myPairs.size()]);
        }

        public String getValue() {
            return this.myValue;
        }

        public List<SimpleTag> getSubTags() {
            return this.mySubTags;
        }

        public void generate(StringBuilder buf) {
            buf.append("<").append(this.getName());
            for (Pair pair : this.getPairs()) {
                buf.append(" ").append(pair.first).append("=\"").append(pair.second).append("\"");
            }
            buf.append(">\n");
            for (SimpleTag tag : this.getSubTags()) {
                tag.generate(buf);
            }
            buf.append("</").append(this.getName()).append(">\n");
        }
    }
}

