/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.IntEnumEditor;
import com.intellij.uiDesigner.propertyInspector.properties.AlignPropertyProvider;
import com.intellij.uiDesigner.propertyInspector.renderers.IntEnumRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AlignProperty
extends Property<RadComponent, Integer> {
    private final boolean myHorizontal;
    private IntEnumRenderer myRenderer;
    private IntEnumEditor myEditor;

    public AlignProperty(boolean horizontal) {
        super(null, horizontal ? "Horizontal Align" : "Vertical Align");
        this.myHorizontal = horizontal;
    }

    @Override
    public Integer getValue(RadComponent component) {
        AlignPropertyProvider provider = AlignProperty.getAlignPropertyProvider(component);
        if (provider != null) {
            return provider.getAlignment(component, this.myHorizontal);
        }
        return Utils.alignFromConstraints((GridConstraints)component.getConstraints(), (boolean)this.myHorizontal);
    }

    private static AlignPropertyProvider getAlignPropertyProvider(RadComponent component) {
        if (component.getParent().getLayoutManager() instanceof AlignPropertyProvider) {
            return (AlignPropertyProvider)((Object)component.getParent().getLayoutManager());
        }
        return null;
    }

    @Override
    protected void setValueImpl(RadComponent component, Integer value) throws Exception {
        int anchorMask = this.myHorizontal ? 12 : 3;
        int fillMask = this.myHorizontal ? 1 : 2;
        int anchor = 0;
        int fill = 0;
        switch (value) {
            case 3: {
                fill = this.myHorizontal ? 1 : 2;
                break;
            }
            case 0: {
                anchor = this.myHorizontal ? 8 : 1;
                break;
            }
            case 2: {
                anchor = this.myHorizontal ? 4 : 2;
            }
        }
        GridConstraints gc = component.getConstraints();
        GridConstraints oldGC = (GridConstraints)gc.clone();
        gc.setAnchor(gc.getAnchor() & ~anchorMask | anchor);
        gc.setFill(gc.getFill() & ~fillMask | fill);
        AlignPropertyProvider provider = AlignProperty.getAlignPropertyProvider(component);
        if (provider != null) {
            provider.setAlignment(component, this.myHorizontal, value);
        }
        component.fireConstraintsChanged(oldGC);
    }

    @Override
    public boolean isModified(RadComponent component) {
        AlignPropertyProvider provider = AlignProperty.getAlignPropertyProvider(component);
        if (provider != null) {
            return provider.isAlignmentModified(component, this.myHorizontal);
        }
        ComponentItem item = component.getPalette().getItem(component.getComponentClassName());
        if (item == null) {
            return false;
        }
        return Utils.alignFromConstraints((GridConstraints)component.getConstraints(), (boolean)this.myHorizontal) != Utils.alignFromConstraints((GridConstraints)item.getDefaultConstraints(), (boolean)this.myHorizontal);
    }

    @Override
    public void resetValue(RadComponent component) throws Exception {
        AlignPropertyProvider provider = AlignProperty.getAlignPropertyProvider(component);
        if (provider != null) {
            provider.resetAlignment(component, this.myHorizontal);
        } else {
            ComponentItem item = component.getPalette().getItem(component.getComponentClassName());
            if (item != null) {
                this.setValueEx(component, Utils.alignFromConstraints((GridConstraints)item.getDefaultConstraints(), (boolean)this.myHorizontal));
            }
        }
    }

    @Override
    @NotNull
    public PropertyRenderer<Integer> getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new IntEnumRenderer(this.getPairs());
        }
        IntEnumRenderer intEnumRenderer = this.myRenderer;
        if (intEnumRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/AlignProperty", "getRenderer"));
        }
        return intEnumRenderer;
    }

    private IntEnumEditor.Pair[] getPairs() {
        return new IntEnumEditor.Pair[]{new IntEnumEditor.Pair(0, this.myHorizontal ? UIDesignerBundle.message("property.left", new Object[0]) : UIDesignerBundle.message("property.top", new Object[0])), new IntEnumEditor.Pair(1, UIDesignerBundle.message("property.center", new Object[0])), new IntEnumEditor.Pair(2, this.myHorizontal ? UIDesignerBundle.message("property.right", new Object[0]) : UIDesignerBundle.message("property.bottom", new Object[0])), new IntEnumEditor.Pair(3, UIDesignerBundle.message("property.fill", new Object[0]))};
    }

    @Override
    public PropertyEditor<Integer> getEditor() {
        if (this.myEditor == null) {
            this.myEditor = new IntEnumEditor(this.getPairs());
        }
        return this.myEditor;
    }
}

