/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.constants;

public interface TiffDirectoryConstants {
    public static final int DIRECTORY_TYPE_UNKNOWN = -1;
    public static final int DIRECTORY_TYPE_ROOT = 0;
    public static final int DIRECTORY_TYPE_SUB = 1;
    public static final int DIRECTORY_TYPE_SUB0 = 1;
    public static final int DIRECTORY_TYPE_SUB1 = 2;
    public static final int DIRECTORY_TYPE_SUB2 = 3;
    public static final int DIRECTORY_TYPE_THUMBNAIL = 2;
    public static final int DIRECTORY_TYPE_EXIF = -2;
    public static final int DIRECTORY_TYPE_GPS = -3;
    public static final int DIRECTORY_TYPE_INTEROPERABILITY = -4;
    public static final int DIRECTORY_TYPE_MAKER_NOTES = -5;
    public static final int DIRECTORY_TYPE_DIR_0 = 0;
    public static final int DIRECTORY_TYPE_DIR_1 = 1;
    public static final int DIRECTORY_TYPE_DIR_2 = 2;
    public static final int DIRECTORY_TYPE_DIR_3 = 3;
    public static final int DIRECTORY_TYPE_DIR_4 = 4;
    public static final ExifDirectoryType TIFF_DIRECTORY_IFD0;
    public static final ExifDirectoryType EXIF_DIRECTORY_IFD0;
    public static final ExifDirectoryType TIFF_DIRECTORY_ROOT;
    public static final ExifDirectoryType TIFF_DIRECTORY_IFD1;
    public static final ExifDirectoryType EXIF_DIRECTORY_IFD1;
    public static final ExifDirectoryType TIFF_DIRECTORY_IFD2;
    public static final ExifDirectoryType EXIF_DIRECTORY_IFD2;
    public static final ExifDirectoryType TIFF_DIRECTORY_IFD3;
    public static final ExifDirectoryType EXIF_DIRECTORY_IFD3;
    public static final ExifDirectoryType EXIF_DIRECTORY_SUB_IFD;
    public static final ExifDirectoryType EXIF_DIRECTORY_SUB_IFD1;
    public static final ExifDirectoryType EXIF_DIRECTORY_SUB_IFD2;
    public static final ExifDirectoryType EXIF_DIRECTORY_INTEROP_IFD;
    public static final ExifDirectoryType EXIF_DIRECTORY_MAKER_NOTES;
    public static final ExifDirectoryType EXIF_DIRECTORY_EXIF_IFD;
    public static final ExifDirectoryType EXIF_DIRECTORY_GPS;
    public static final ExifDirectoryType EXIF_DIRECTORY_UNKNOWN;
    public static final ExifDirectoryType[] EXIF_DIRECTORIES;

    static {
        EXIF_DIRECTORY_IFD0 = TIFF_DIRECTORY_IFD0 = new ExifDirectoryType.Image(0, "IFD0");
        TIFF_DIRECTORY_ROOT = TIFF_DIRECTORY_IFD0;
        EXIF_DIRECTORY_IFD1 = TIFF_DIRECTORY_IFD1 = new ExifDirectoryType.Image(1, "IFD1");
        EXIF_DIRECTORY_IFD2 = TIFF_DIRECTORY_IFD2 = new ExifDirectoryType.Image(2, "IFD2");
        EXIF_DIRECTORY_IFD3 = TIFF_DIRECTORY_IFD3 = new ExifDirectoryType.Image(3, "IFD3");
        EXIF_DIRECTORY_SUB_IFD = TIFF_DIRECTORY_IFD1;
        EXIF_DIRECTORY_SUB_IFD1 = TIFF_DIRECTORY_IFD2;
        EXIF_DIRECTORY_SUB_IFD2 = TIFF_DIRECTORY_IFD3;
        EXIF_DIRECTORY_INTEROP_IFD = new ExifDirectoryType.Special(-4, "Interop IFD");
        EXIF_DIRECTORY_MAKER_NOTES = new ExifDirectoryType.Special(-5, "Maker Notes");
        EXIF_DIRECTORY_EXIF_IFD = new ExifDirectoryType.Special(-2, "Exif IFD");
        EXIF_DIRECTORY_GPS = new ExifDirectoryType.Special(-3, "GPS IFD");
        EXIF_DIRECTORY_UNKNOWN = null;
        EXIF_DIRECTORIES = new ExifDirectoryType[]{TIFF_DIRECTORY_ROOT, EXIF_DIRECTORY_EXIF_IFD, TIFF_DIRECTORY_IFD0, EXIF_DIRECTORY_IFD0, TIFF_DIRECTORY_IFD1, EXIF_DIRECTORY_IFD1, TIFF_DIRECTORY_IFD2, EXIF_DIRECTORY_IFD2, EXIF_DIRECTORY_INTEROP_IFD, EXIF_DIRECTORY_MAKER_NOTES, EXIF_DIRECTORY_SUB_IFD, EXIF_DIRECTORY_SUB_IFD1, EXIF_DIRECTORY_SUB_IFD2, EXIF_DIRECTORY_GPS};
    }

    public static abstract class ExifDirectoryType {
        public final int directoryType;
        public final String name;

        public ExifDirectoryType(int directoryType, String name) {
            this.directoryType = directoryType;
            this.name = name;
        }

        public abstract boolean isImageDirectory();

        public static class Special
        extends ExifDirectoryType {
            public Special(int directoryType, String name) {
                super(directoryType, name);
            }

            @Override
            public boolean isImageDirectory() {
                return false;
            }
        }

        public static class Image
        extends ExifDirectoryType {
            public Image(int directoryType, String name) {
                super(directoryType, name);
            }

            @Override
            public boolean isImageDirectory() {
                return true;
            }
        }
    }
}

