/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.syntaxChecks;

import lombok.ast.Identifier;
import lombok.ast.Message;
import lombok.ast.Node;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.syntaxChecks.MessageKey;

public class BasicChecks {
    public void checkNameOfIdentifier(Identifier identifier) {
        String n = identifier.astValue();
        if (n.length() == 0) {
            identifier.addMessage(Message.error(MessageKey.IDENTIFIER_EMPTY, "Empty Identifier"));
            return;
        }
        if (!Character.isJavaIdentifierStart(n.charAt(0))) {
            identifier.addMessage(Message.error(MessageKey.IDENTIFIER_INVALID, "Not a legal start character for a java identifier: " + n.charAt(0)));
            return;
        }
        for (int i = 1; i < n.length(); ++i) {
            if (Character.isJavaIdentifierPart(n.charAt(i))) continue;
            identifier.addMessage(Message.error(MessageKey.IDENTIFIER_INVALID, "Not a legal character in a java identifier: " + n.charAt(i)));
            return;
        }
    }

    static void checkVarDefIsSimple(Node node, Node rawVarDef, String descriptionOfOuter, String descriptionOfRelation) {
        if (!(rawVarDef instanceof VariableDefinition)) {
            return;
        }
        switch (((VariableDefinition)rawVarDef).rawVariables().size()) {
            case 0: {
                return;
            }
            case 1: {
                break;
            }
            default: {
                rawVarDef.addMessage(Message.error(MessageKey.VARIABLEDEFINITION_ONLY_ONE, String.format("%s can only declare one %s variable", descriptionOfOuter, descriptionOfRelation)));
            }
        }
        for (VariableDefinitionEntry entry : ((VariableDefinition)rawVarDef).astVariables()) {
            if (entry.rawInitializer() == null) continue;
            entry.addMessage(Message.error(MessageKey.VARIABLEDEFINITIONENTRY_INITIALIZER_NOT_ALLOWED, String.format("%s can only declare %s variables without an initializer", descriptionOfOuter, descriptionOfRelation)));
        }
    }
}

