/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSdkUtil {
    @NotNull
    public static List<File> getJdkClassesRoots(@NotNull File home, boolean isJre) {
        File classesDir;
        String[] stringArray;
        File libDir;
        File[] jarDirs;
        if (home == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "home", "org/jetbrains/jps/model/java/impl/JavaSdkUtil", "getJdkClassesRoots"));
        }
        if (SystemInfo.isMac && !home.getName().startsWith("mockJDK")) {
            File libEndorsedDir;
            File openJdkRtJar = new File(home, "jre/lib/rt.jar");
            if (openJdkRtJar.exists() && !openJdkRtJar.isDirectory()) {
                File libDir2 = new File(home, "lib");
                File classesDir2 = openJdkRtJar.getParentFile();
                File file = new File(openJdkRtJar.getParentFile(), "ext");
                libEndorsedDir = new File(libDir2, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir2, classesDir2, file};
            } else {
                File libDir2 = new File(home, "lib");
                File classesDir2 = new File(home, "../Classes");
                File file = new File(libDir2, "ext");
                libEndorsedDir = new File(libDir2, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir2, classesDir2, file};
            }
        } else if (new File(home, "lib/modules").isDirectory()) {
            libDir = new File(home, "lib");
            jarDirs = new File[]{libDir};
        } else {
            libDir = isJre ? new File(home, "lib") : new File(home, "jre/lib");
            File libExtDir = new File(libDir, "ext");
            File libEndorsedDir = new File(libDir, "endorsed");
            jarDirs = new File[]{libEndorsedDir, libDir, libExtDir};
        }
        FileFilter jarFileFilter = FileFilters.filesWithExtension((String)"jar");
        THashSet pathFilter = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        ArrayList rootFiles = ContainerUtil.newArrayList();
        for (File jarDir : jarDirs) {
            File[] jarFiles;
            if (jarDir == null || !jarDir.isDirectory()) continue;
            for (File jarFile : jarFiles = jarDir.listFiles(jarFileFilter)) {
                String canonicalPath;
                String jarFileName = jarFile.getName();
                if (jarFileName.equals("alt-rt.jar") || jarFileName.equals("alt-string.jar") || (canonicalPath = JavaSdkUtil.getCanonicalPath(jarFile)) == null || !pathFilter.add(canonicalPath)) continue;
                rootFiles.add(jarFile);
            }
        }
        for (String relativePath : stringArray = new String[]{"jre/bin/default", "jre/lib/i386/default", "jre/lib/amd64/default"}) {
            File[] vmJarDirs = new File(home, relativePath).listFiles(FileUtilRt.ALL_DIRECTORIES);
            if (vmJarDirs == null) continue;
            for (File dir : vmJarDirs) {
                File vmJar;
                if (!dir.getName().startsWith("jclSC") || !(vmJar = new File(dir, "vm.jar")).isFile()) continue;
                rootFiles.add(vmJar);
            }
        }
        File classesZip = new File(home, "lib/classes.zip");
        if (classesZip.isFile()) {
            rootFiles.add(classesZip);
        }
        if (rootFiles.isEmpty() && (classesDir = new File(home, "classes")).isDirectory()) {
            rootFiles.add(classesDir);
        }
        ArrayList arrayList = rootFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JavaSdkUtil", "getJdkClassesRoots"));
        }
        return arrayList;
    }

    @Nullable
    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }
}

