/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrContainerConverter
extends GrTypeConverter {
    @Override
    public boolean isAllowedInMethodCall() {
        return false;
    }

    @Override
    @Nullable
    public Boolean isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context) {
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrContainerConverter", "isConvertible"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rType", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrContainerConverter", "isConvertible"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrContainerConverter", "isConvertible"));
        }
        if (lType instanceof PsiArrayType) {
            PsiType lComponentType = ((PsiArrayType)lType).getComponentType();
            PsiType rComponentType = ClosureParameterEnhancer.findTypeForIteration(rType, (PsiElement)context);
            if (rComponentType != null && TypesUtil.isAssignable(lComponentType, rComponentType, context)) {
                return Boolean.TRUE;
            }
        }
        return null;
    }
}

