/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrLabeledStatementImpl
extends GroovyPsiElementImpl
implements GrLabeledStatement {
    public GrLabeledStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitLabeledStatement(this);
    }

    public String toString() {
        return "Labeled statement";
    }

    @NotNull
    public String getLabelName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl", "getLabelName"));
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement getLabel() {
        PsiElement label = this.findChildByType(GroovyTokenTypes.mIDENT);
        assert (label != null);
        PsiElement psiElement = label;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl", "getLabel"));
        }
        return psiElement;
    }

    @Override
    @Nullable
    public GrStatement getStatement() {
        return (GrStatement)this.findChildByClass(GrStatement.class);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl", "processDeclarations"));
        }
        GrStatement statement = this.getStatement();
        return statement == null || statement == lastParent || statement.processDeclarations(processor, state, lastParent, place);
    }

    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl", "getUseScope"));
        }
        return localSearchScope;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl", "setName"));
        }
        PsiElement labelElement = this.getLabel();
        PsiElement newLabel = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceNameFromText(name);
        labelElement.replace(newLabel);
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement label = this.getLabel();
        String string = label.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement psiElement = this.getLabel();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl", "getNameIdentifierGroovy"));
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNameIdentifierGroovy();
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl", "deleteChildInternal"));
        }
        GrStatement statement = this.getStatement();
        if (statement != null && child == statement.getNode()) {
            this.delete();
        } else {
            super.deleteChildInternal(child);
        }
    }
}

