/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.javaView;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyShortNamesCache;

public class GroovyClassFinder
extends PsiElementFinder {
    private final GroovyShortNamesCache myCache;

    public GroovyClassFinder(Project project) {
        this.myCache = GroovyShortNamesCache.getGroovyShortNamesCache(project);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/plugins/groovy/lang/psi/impl/javaView/GroovyClassFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/psi/impl/javaView/GroovyClassFinder", "findClass"));
        }
        List<PsiClass> classes = this.myCache.getClassesByFQName(qualifiedName, scope, true);
        return classes.isEmpty() ? null : classes.get(0);
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/plugins/groovy/lang/psi/impl/javaView/GroovyClassFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/psi/impl/javaView/GroovyClassFinder", "findClasses"));
        }
        List<PsiClass> classes = this.myCache.getClassesByFQName(qualifiedName, scope, true);
        PsiClass[] psiClassArray = classes.isEmpty() ? PsiClass.EMPTY_ARRAY : classes.toArray(new PsiClass[classes.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/javaView/GroovyClassFinder", "findClasses"));
        }
        return psiClassArray;
    }
}

