/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;

public class GroovyResolveResultImpl
implements GroovyResolveResult {
    private final PsiElement myElement;
    private final boolean myIsAccessible;
    private final boolean myIsStaticsOK;
    private final boolean myIsApplicable;
    private final PsiSubstitutor mySubstitutor;
    private final boolean myIsInvokedOnProperty;
    private final PsiElement myCurrentFileResolveContext;
    private final SpreadState mySpreadState;

    public GroovyResolveResultImpl(@NotNull PsiElement element, boolean isAccessible) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyResolveResultImpl", "<init>"));
        }
        this(element, null, null, PsiSubstitutor.EMPTY, isAccessible, true, false, true);
    }

    public GroovyResolveResultImpl(@NotNull PsiElement element, @Nullable PsiElement resolveContext, @Nullable SpreadState spreadState, @NotNull PsiSubstitutor substitutor, boolean isAccessible, boolean staticsOK) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyResolveResultImpl", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyResolveResultImpl", "<init>"));
        }
        this(element, resolveContext, spreadState, substitutor, isAccessible, staticsOK, false, true);
    }

    public GroovyResolveResultImpl(@NotNull PsiElement element, @Nullable PsiElement resolveContext, @Nullable SpreadState spreadState, @NotNull PsiSubstitutor substitutor, boolean isAccessible, boolean staticsOK, boolean isInvokedOnProperty, boolean isApplicable) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyResolveResultImpl", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyResolveResultImpl", "<init>"));
        }
        this.myCurrentFileResolveContext = resolveContext;
        this.myElement = element;
        this.myIsAccessible = isAccessible;
        this.mySubstitutor = substitutor;
        this.myIsStaticsOK = staticsOK;
        this.myIsInvokedOnProperty = isInvokedOnProperty;
        this.mySpreadState = spreadState;
        this.myIsApplicable = isApplicable;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyResolveResultImpl", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    public boolean isAccessible() {
        return this.myIsAccessible;
    }

    @Override
    public boolean isStaticsOK() {
        return this.myIsStaticsOK;
    }

    @Override
    public boolean isApplicable() {
        return this.myIsApplicable;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    public boolean isValidResult() {
        return this.isAccessible() && this.isApplicable() && this.isStaticsOK();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroovyResolveResultImpl that = (GroovyResolveResultImpl)o;
        return this.myIsAccessible == that.myIsAccessible && this.myElement.getManager().areElementsEquivalent(this.myElement, that.myElement);
    }

    public int hashCode() {
        String name;
        int result = 0;
        if (this.myElement instanceof PsiNamedElement && (name = ((PsiNamedElement)this.myElement).getName()) != null) {
            result = name.hashCode();
        }
        result = 31 * result + (this.myIsAccessible ? 1 : 0);
        return result;
    }

    @Override
    @Nullable
    public PsiElement getCurrentFileResolveContext() {
        return this.myCurrentFileResolveContext;
    }

    @Override
    public boolean isInvokedOnProperty() {
        return this.myIsInvokedOnProperty;
    }

    @Override
    public SpreadState getSpreadState() {
        return this.mySpreadState;
    }

    public String toString() {
        return "GroovyResolveResultImpl{myElement=" + this.myElement + ", mySubstitutor=" + this.mySubstitutor + '}';
    }

    @NotNull
    public static GroovyResolveResult from(@NotNull PsiClassType.ClassResolveResult classResolveResult) {
        if (classResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classResolveResult", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyResolveResultImpl", "from"));
        }
        if (classResolveResult.getElement() == null) {
            GroovyResolveResult groovyResolveResult = GroovyResolveResult.EMPTY_RESULT;
            if (groovyResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyResolveResultImpl", "from"));
            }
            return groovyResolveResult;
        }
        GroovyResolveResultImpl groovyResolveResultImpl = new GroovyResolveResultImpl((PsiElement)classResolveResult.getElement(), null, null, classResolveResult.getSubstitutor(), classResolveResult.isAccessible(), classResolveResult.isStaticsScopeCorrect(), false, classResolveResult.isValidResult());
        if (groovyResolveResultImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyResolveResultImpl", "from"));
        }
        return groovyResolveResultImpl;
    }
}

