/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.openapi.impl.RenameRefactoringImpl;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.ClassNameDiffersFromFileNamePredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class RenameFileWithClassIntention
extends Intention
implements Consumer<GrTypeDefinition> {
    private String myNewFileName = null;

    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/RenameFileWithClassIntention", "processIntention"));
        }
        PsiFile file = element.getContainingFile();
        new RenameRefactoringImpl(project, (PsiElement)file, this.myNewFileName, true, true).run();
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyIntentionsBundle.message("rename.file.to.0", this.myNewFileName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/RenameFileWithClassIntention", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ClassNameDiffersFromFileNamePredicate classNameDiffersFromFileNamePredicate = new ClassNameDiffersFromFileNamePredicate(this);
        if (classNameDiffersFromFileNamePredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/RenameFileWithClassIntention", "getElementPredicate"));
        }
        return classNameDiffersFromFileNamePredicate;
    }

    public void consume(GrTypeDefinition def) {
        String name = def.getName();
        PsiFile file = def.getContainingFile();
        this.myNewFileName = name + "." + FileUtilRt.getExtension((String)file.getName());
    }
}

