/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;

class DonePromise<T>
extends Promise<T>
implements Getter<T> {
    private final T result;

    public DonePromise(T result) {
        this.result = result;
    }

    @Override
    @NotNull
    public Promise<T> done(@NotNull Consumer<? super T> done) {
        if (done == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "org/jetbrains/concurrency/DonePromise", "done"));
        }
        if (!AsyncPromise.isObsolete(done)) {
            done.consume(this.result);
        }
        DonePromise donePromise = this;
        if (donePromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "done"));
        }
        return donePromise;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull AsyncPromise<? super T> fulfilled) {
        if (fulfilled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fulfilled", "org/jetbrains/concurrency/DonePromise", "processed"));
        }
        fulfilled.setResult(this.result);
        DonePromise donePromise = this;
        if (donePromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "processed"));
        }
        return donePromise;
    }

    @Override
    public Promise<T> processed(@NotNull Consumer<? super T> processed) {
        if (processed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "org/jetbrains/concurrency/DonePromise", "processed"));
        }
        this.done(processed);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> rejected) {
        if (rejected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rejected", "org/jetbrains/concurrency/DonePromise", "rejected"));
        }
        DonePromise donePromise = this;
        if (donePromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "rejected"));
        }
        return donePromise;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done) {
        if (done == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "org/jetbrains/concurrency/DonePromise", "then"));
        }
        if (done instanceof Obsolescent && ((Obsolescent)done).isObsolete()) {
            Promise promise = Promise.reject("obsolete");
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "then"));
            }
            return promise;
        }
        Promise<Object> promise = Promise.resolve(done.fun(this.result));
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "then"));
        }
        return promise;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull AsyncFunction<? super T, SUB_RESULT> done) {
        if (done == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "org/jetbrains/concurrency/DonePromise", "thenAsync"));
        }
        Promise<SUB_RESULT> promise = done.fun(this.result);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "thenAsync"));
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise.State getState() {
        Promise.State state = Promise.State.FULFILLED;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "getState"));
        }
        return state;
    }

    public T get() {
        return this.result;
    }

    @Override
    public void notify(@NotNull AsyncPromise<? super T> child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/concurrency/DonePromise", "notify"));
        }
        child.setResult(this.result);
    }
}

