/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ModuleContextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConvertContext
extends ConvertContext {
    @Override
    public final XmlTag getTag() {
        return this.getInvocationElement().getXmlTag();
    }

    @Override
    @Nullable
    public XmlElement getXmlElement() {
        return this.getInvocationElement().getXmlElement();
    }

    @Override
    @NotNull
    public final XmlFile getFile() {
        XmlFile xmlFile = DomUtil.getFile(this.getInvocationElement());
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/AbstractConvertContext", "getFile"));
        }
        return xmlFile;
    }

    @Override
    public Module getModule() {
        DomFileElement fileElement = DomUtil.getFileElement(this.getInvocationElement());
        if (fileElement == null) {
            XmlElement xmlElement = this.getInvocationElement().getXmlElement();
            return xmlElement == null ? null : ModuleUtilCore.findModuleForPsiElement(xmlElement);
        }
        return fileElement.isValid() ? fileElement.getRootElement().getModule() : null;
    }

    @Override
    public PsiManager getPsiManager() {
        return this.getFile().getManager();
    }

    @Override
    @Nullable
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope scope = null;
        Module[] modules = this.getConvertContextModules();
        if (modules.length != 0) {
            PsiFile file = this.getFile();
            VirtualFile virtualFile = (file = file.getOriginalFile()).getVirtualFile();
            if (virtualFile != null) {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance(file.getProject()).getFileIndex();
                boolean tests = fileIndex.isInTestSourceContent(virtualFile);
                for (Module module : modules) {
                    scope = scope == null ? module.getModuleRuntimeScope(tests) : scope.union(module.getModuleRuntimeScope(tests));
                }
            }
        }
        return scope;
    }

    @NotNull
    private Module[] getConvertContextModules() {
        Module[] modules = ModuleContextProvider.getModules(this.getFile());
        if (modules.length > 0) {
            if (modules == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/AbstractConvertContext", "getConvertContextModules"));
            }
            return modules;
        }
        Module module = this.getModule();
        if (module != null) {
            Module[] moduleArray = new Module[]{module};
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/AbstractConvertContext", "getConvertContextModules"));
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/AbstractConvertContext", "getConvertContextModules"));
        }
        return Module.EMPTY_ARRAY;
    }
}

