/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.util.containers.HashMap;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CertificateWrapper {
    @NonNls
    public static final String NOT_AVAILABLE = "N/A";
    private final X509Certificate myCertificate;
    private final Map<String, String> myIssuerFields;
    private final Map<String, String> mySubjectFields;

    public CertificateWrapper(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "com/intellij/util/net/ssl/CertificateWrapper", "<init>"));
        }
        this.myCertificate = certificate;
        this.myIssuerFields = CertificateWrapper.extractFields(certificate.getIssuerX500Principal());
        this.mySubjectFields = CertificateWrapper.extractFields(certificate.getSubjectX500Principal());
    }

    @NotNull
    public String getIssuerField(@NotNull CommonField name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/net/ssl/CertificateWrapper", "getIssuerField"));
        }
        String field = this.myIssuerFields.get(name.getShortName());
        String string = field == null ? NOT_AVAILABLE : field;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateWrapper", "getIssuerField"));
        }
        return string;
    }

    @NotNull
    public String getSubjectField(@NotNull CommonField name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/net/ssl/CertificateWrapper", "getSubjectField"));
        }
        String field = this.mySubjectFields.get(name.getShortName());
        String string = field == null ? NOT_AVAILABLE : field;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateWrapper", "getSubjectField"));
        }
        return string;
    }

    @NotNull
    public String getSha256Fingerprint() {
        String string;
        try {
            string = DigestUtils.sha256Hex((byte[])this.myCertificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            if (NOT_AVAILABLE == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateWrapper", "getSha256Fingerprint"));
            }
            return NOT_AVAILABLE;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateWrapper", "getSha256Fingerprint"));
        }
        return string;
    }

    public String getSha1Fingerprint() {
        try {
            return DigestUtils.sha1Hex((byte[])this.myCertificate.getEncoded());
        }
        catch (Exception e) {
            return NOT_AVAILABLE;
        }
    }

    public boolean isValid() {
        try {
            this.myCertificate.checkValidity();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isExpired() {
        return new Date().getTime() > this.myCertificate.getNotAfter().getTime();
    }

    public boolean isNotYetValid() {
        return new Date().getTime() < this.myCertificate.getNotBefore().getTime();
    }

    public boolean isSelfSigned() {
        return this.myCertificate.getIssuerX500Principal().equals(this.myCertificate.getSubjectX500Principal());
    }

    public int getVersion() {
        return this.myCertificate.getVersion();
    }

    @NotNull
    public String getSerialNumber() {
        String string = this.myCertificate.getSerialNumber().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/ssl/CertificateWrapper", "getSerialNumber"));
        }
        return string;
    }

    public X509Certificate getCertificate() {
        return this.myCertificate;
    }

    public X500Principal getIssuerX500Principal() {
        return this.myCertificate.getIssuerX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        return this.myCertificate.getSubjectX500Principal();
    }

    public Date getNotBefore() {
        return this.myCertificate.getNotBefore();
    }

    public Date getNotAfter() {
        return this.myCertificate.getNotAfter();
    }

    public Map<String, String> getIssuerFields() {
        return this.myIssuerFields;
    }

    public Map<String, String> getSubjectFields() {
        return this.mySubjectFields;
    }

    private static Map<String, String> extractFields(X500Principal principal) {
        HashMap fields = new HashMap();
        for (String field : principal.getName().split("(?<!\\\\),")) {
            String[] parts = field.trim().split("=", 2);
            if (parts.length != 2) continue;
            fields.put(parts[0], parts[1].replaceAll("\\\\,", ","));
        }
        return Collections.unmodifiableMap(fields);
    }

    public final boolean equals(Object other) {
        return other instanceof CertificateWrapper && this.myCertificate.equals(((CertificateWrapper)other).getCertificate());
    }

    public final int hashCode() {
        return this.myCertificate.hashCode();
    }

    public static enum CommonField {
        COMMON_NAME("CN", "Common Name"),
        ORGANIZATION("O", "Organization"),
        ORGANIZATION_UNIT("OU", "Organizational Unit"),
        LOCATION("L", "Locality"),
        COUNTRY("C", "Country"),
        STATE("ST", "State or Province");

        private final String myShortName;
        private final String myLongName;

        private CommonField(String shortName, String longName) {
            if (shortName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/util/net/ssl/CertificateWrapper$CommonField", "<init>"));
            }
            if (longName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "longName", "com/intellij/util/net/ssl/CertificateWrapper$CommonField", "<init>"));
            }
            this.myShortName = shortName;
            this.myLongName = longName;
        }

        public String getShortName() {
            return this.myShortName;
        }

        public String getLongName() {
            return this.myLongName;
        }
    }
}

