/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.FileContentUtilCore;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentUtil
extends FileContentUtilCore {
    public static void setFileText(@Nullable Project project, VirtualFile virtualFile, String text) throws IOException {
        if (project == null) {
            project = ProjectUtil.guessProjectForFile(virtualFile);
        }
        if (project != null) {
            Document document;
            PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project);
            Document document2 = document = psiFile == null ? null : psiDocumentManager.getDocument(psiFile);
            if (document != null) {
                document.setText(text != null ? text : "");
                psiDocumentManager.commitDocument(document);
                FileDocumentManager.getInstance().saveDocument(document);
                return;
            }
        }
        VfsUtil.saveText(virtualFile, text != null ? text : "");
        virtualFile.refresh(false, false);
    }

    public static void reparseFiles(@NotNull Project project, @NotNull Collection<VirtualFile> files, boolean includeOpenFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/FileContentUtil", "reparseFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/util/FileContentUtil", "reparseFiles"));
        }
        LinkedHashSet<VirtualFile> fileSet = new LinkedHashSet<VirtualFile>(files);
        if (includeOpenFiles) {
            for (VirtualFile open : FileEditorManager.getInstance(project).getOpenFiles()) {
                if (fileSet.contains(open)) continue;
                fileSet.add(open);
            }
        }
        FileContentUtilCore.reparseFiles(fileSet);
    }

    public static void reparseOpenedFiles() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileContentUtil.reparseFiles(project, Collections.<VirtualFile>emptyList(), true);
        }
    }
}

