/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;

public class RowIcon
implements Icon {
    private final Alignment myAlignment;
    private final Icon[] myIcons;
    private int myWidth;
    private int myHeight;

    public RowIcon(int iconCount) {
        this(iconCount, Alignment.TOP);
    }

    public RowIcon(int iconCount, Alignment alignment) {
        this.myAlignment = alignment;
        this.myIcons = new Icon[iconCount];
    }

    public RowIcon(Icon ... icons) {
        this(icons.length);
        System.arraycopy(icons, 0, this.myIcons, 0, icons.length);
        this.recalculateSize();
    }

    public int hashCode() {
        return this.myIcons.length > 0 ? this.myIcons[0].hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof RowIcon && Arrays.equals(((RowIcon)obj).myIcons, this.myIcons);
    }

    public int getIconCount() {
        return this.myIcons.length;
    }

    public void setIcon(Icon icon, int layer) {
        this.myIcons[layer] = icon;
        this.recalculateSize();
    }

    public Icon getIcon(int index) {
        return this.myIcons[index];
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int _x = x;
        int _y = y;
        for (Icon icon : this.myIcons) {
            if (icon == null) continue;
            switch (this.myAlignment) {
                case TOP: {
                    _y = y;
                    break;
                }
                case CENTER: {
                    _y = y + (this.myHeight - icon.getIconHeight()) / 2;
                    break;
                }
                case BOTTOM: {
                    _y = y + (this.myHeight - icon.getIconHeight());
                }
            }
            icon.paintIcon(c, g, _x, _y);
            _x += icon.getIconWidth();
        }
    }

    @Override
    public int getIconWidth() {
        return this.myWidth;
    }

    @Override
    public int getIconHeight() {
        return this.myHeight;
    }

    private void recalculateSize() {
        int width = 0;
        int height = 0;
        for (Icon icon : this.myIcons) {
            if (icon == null) continue;
            width += icon.getIconWidth();
            height = Math.max(height, icon.getIconHeight());
        }
        this.myWidth = width;
        this.myHeight = height;
    }

    public String toString() {
        return "Row icon. myIcons=" + Arrays.asList(this.myIcons);
    }

    public static enum Alignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

