/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.plaf.FontUIResource;

public enum RelativeFont implements PropertyChangeListener
{
    PLAIN(0, 0.0f),
    BOLD(1, 0.0f),
    ITALIC(2, 0.0f),
    LARGE(1.0f),
    SMALL(-1.0f),
    HUGE(2.0f),
    TINY(-2.0f);

    private static final String PROPERTY = "font";
    private final int myStyle;
    private final float mySize;

    private RelativeFont(float size) {
        this.myStyle = -1;
        this.mySize = size;
    }

    private RelativeFont(int style, float size) {
        this.myStyle = style & 3;
        this.mySize = size;
    }

    public <T extends Component> T install(T component) {
        Font font = this.derive(component.getFont());
        if (font != null) {
            component.setFont(new MyFont(font));
        }
        component.addPropertyChangeListener(PROPERTY, this);
        return component;
    }

    public Font derive(Font font) {
        if (font != null) {
            if (-1 != this.myStyle && this.myStyle != font.getStyle()) {
                return this.mySize != 0.0f ? font.deriveFont(this.myStyle, this.mySize + font.getSize2D()) : font.deriveFont(this.myStyle);
            }
            if (this.mySize != 0.0f) {
                return font.deriveFont(this.mySize + font.getSize2D());
            }
        }
        return font;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getNewValue() instanceof MyFont) && event.getSource() instanceof Component && PROPERTY.equals(event.getPropertyName())) {
            Component component = (Component)event.getSource();
            Font font = this.derive(event.getNewValue() instanceof Font ? (Font)event.getNewValue() : component.getFont());
            if (font != null) {
                component.setFont(new MyFont(font));
            }
        }
    }

    private static final class MyFont
    extends FontUIResource {
        private MyFont(Font font) {
            super(font);
        }
    }
}

