/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.IssueNavigationLink;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@State(name="IssueNavigationConfiguration", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/vcs.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class IssueNavigationConfiguration
extends SimpleModificationTracker
implements PersistentStateComponent<IssueNavigationConfiguration> {
    private List<IssueNavigationLink> myLinks = new ArrayList<IssueNavigationLink>();

    public static IssueNavigationConfiguration getInstance(Project project) {
        return PeriodicalTasksCloser.getInstance().safeGetService(project, IssueNavigationConfiguration.class);
    }

    public List<IssueNavigationLink> getLinks() {
        return this.myLinks;
    }

    public void setLinks(List<IssueNavigationLink> links) {
        this.myLinks = new ArrayList<IssueNavigationLink>(links);
        this.incModificationCount();
    }

    @Override
    public IssueNavigationConfiguration getState() {
        return this;
    }

    @Override
    public void loadState(IssueNavigationConfiguration state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public List<LinkMatch> findIssueLinks(CharSequence text) {
        ArrayList<LinkMatch> result = new ArrayList<LinkMatch>();
        for (IssueNavigationLink link : this.myLinks) {
            Pattern issuePattern = link.getIssuePattern();
            Matcher m = issuePattern.matcher(text);
            while (m.find()) {
                String replacement = issuePattern.matcher(m.group(0)).replaceFirst(link.getLinkRegexp());
                IssueNavigationConfiguration.addMatch(result, new TextRange(m.start(), m.end()), replacement);
            }
        }
        Matcher m = URLUtil.URL_PATTERN.matcher(text);
        while (m.find()) {
            IssueNavigationConfiguration.addMatch(result, new TextRange(m.start(), m.end()), m.group());
        }
        Collections.sort(result);
        return result;
    }

    private static void addMatch(List<LinkMatch> result, TextRange range, String replacement) {
        Iterator<LinkMatch> iterator = result.iterator();
        while (iterator.hasNext()) {
            LinkMatch oldMatch = iterator.next();
            if (range.contains(oldMatch.getRange())) {
                iterator.remove();
                continue;
            }
            if (!oldMatch.getRange().contains(range)) continue;
            return;
        }
        result.add(new LinkMatch(range, replacement));
    }

    public static class LinkMatch
    implements Comparable {
        private final TextRange myRange;
        private final String myTargetUrl;

        public LinkMatch(TextRange range, String targetUrl) {
            this.myRange = range;
            this.myTargetUrl = targetUrl;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        public String getTargetUrl() {
            return this.myTargetUrl;
        }

        public int compareTo(Object o) {
            if (!(o instanceof LinkMatch)) {
                return 0;
            }
            LinkMatch rhs = (LinkMatch)o;
            return this.myRange.getStartOffset() - rhs.getRange().getStartOffset();
        }
    }
}

