/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.SavingRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManager
implements SavingRequestor {
    @NotNull
    public static FileDocumentManager getInstance() {
        FileDocumentManager fileDocumentManager = ApplicationManager.getApplication().getComponent(FileDocumentManager.class);
        if (fileDocumentManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/FileDocumentManager", "getInstance"));
        }
        return fileDocumentManager;
    }

    @Nullable
    public abstract Document getDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract Document getCachedDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getFile(@NotNull Document var1);

    public abstract void saveAllDocuments();

    public abstract void saveDocument(@NotNull Document var1);

    public abstract void saveDocumentAsIs(@NotNull Document var1);

    @NotNull
    public abstract Document[] getUnsavedDocuments();

    public abstract boolean isDocumentUnsaved(@NotNull Document var1);

    public abstract boolean isFileModified(@NotNull VirtualFile var1);

    public abstract void reloadFromDisk(@NotNull Document var1);

    @NotNull
    public abstract String getLineSeparator(@Nullable VirtualFile var1, @Nullable Project var2);

    public abstract boolean requestWriting(@NotNull Document var1, @Nullable Project var2);

    public static boolean fileForDocumentCheckedOutSuccessfully(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/FileDocumentManager", "fileForDocumentCheckedOutSuccessfully"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/FileDocumentManager", "fileForDocumentCheckedOutSuccessfully"));
        }
        return FileDocumentManager.getInstance().requestWriting(document, project);
    }

    public abstract void reloadFiles(VirtualFile ... var1);
}

