/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DelegatingExternalSystemSettingsListener<S extends ExternalProjectSettings>
implements ExternalSystemSettingsListener<S> {
    @NotNull
    private final ExternalSystemSettingsListener<S> myDelegate;

    public DelegatingExternalSystemSettingsListener(@NotNull ExternalSystemSettingsListener<S> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/externalSystem/settings/DelegatingExternalSystemSettingsListener", "<init>"));
        }
        this.myDelegate = delegate;
    }

    @Override
    public void onProjectRenamed(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/openapi/externalSystem/settings/DelegatingExternalSystemSettingsListener", "onProjectRenamed"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/externalSystem/settings/DelegatingExternalSystemSettingsListener", "onProjectRenamed"));
        }
        this.myDelegate.onProjectRenamed(oldName, newName);
    }

    @Override
    public void onProjectsLinked(@NotNull Collection<S> settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/settings/DelegatingExternalSystemSettingsListener", "onProjectsLinked"));
        }
        this.myDelegate.onProjectsLinked(settings);
    }

    @Override
    public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
        if (linkedProjectPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPaths", "com/intellij/openapi/externalSystem/settings/DelegatingExternalSystemSettingsListener", "onProjectsUnlinked"));
        }
        this.myDelegate.onProjectsUnlinked(linkedProjectPaths);
    }

    @Override
    public void onUseAutoImportChange(boolean currentValue, @NotNull String linkedProjectPath) {
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "com/intellij/openapi/externalSystem/settings/DelegatingExternalSystemSettingsListener", "onUseAutoImportChange"));
        }
        this.myDelegate.onUseAutoImportChange(currentValue, linkedProjectPath);
    }

    @Override
    public void onBulkChangeStart() {
        this.myDelegate.onBulkChangeStart();
    }

    @Override
    public void onBulkChangeEnd() {
        this.myDelegate.onBulkChangeEnd();
    }
}

