/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import org.jetbrains.annotations.NotNull;

public class ActionStub
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.ActionStub");
    private final String myClassName;
    private final String myProjectType;
    private final String myId;
    private final String myText;
    private final ClassLoader myLoader;
    private final PluginId myPluginId;
    private final String myIconPath;

    public ActionStub(@NotNull String actionClass, @NotNull String id, @NotNull String text, ClassLoader loader, PluginId pluginId, String iconPath, String projectType) {
        if (actionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionClass", "com/intellij/openapi/actionSystem/ActionStub", "<init>"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/actionSystem/ActionStub", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/actionSystem/ActionStub", "<init>"));
        }
        this.myLoader = loader;
        this.myClassName = actionClass;
        this.myProjectType = projectType;
        LOG.assertTrue(!id.isEmpty());
        this.myId = id;
        this.myText = text;
        this.myPluginId = pluginId;
        this.myIconPath = iconPath;
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ActionStub", "getClassName"));
        }
        return string;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ActionStub", "getId"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ActionStub", "getText"));
        }
        return string;
    }

    public ClassLoader getLoader() {
        return this.myLoader;
    }

    public PluginId getPluginId() {
        return this.myPluginId;
    }

    public String getIconPath() {
        return this.myIconPath;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        throw new UnsupportedOperationException();
    }

    public final void initAction(@NotNull AnAction targetAction) {
        if (targetAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetAction", "com/intellij/openapi/actionSystem/ActionStub", "initAction"));
        }
        Presentation sourcePresentation = this.getTemplatePresentation();
        Presentation targetPresentation = targetAction.getTemplatePresentation();
        if (targetPresentation.getIcon() == null && sourcePresentation.getIcon() != null) {
            targetPresentation.setIcon(sourcePresentation.getIcon());
        }
        if (targetPresentation.getText() == null && sourcePresentation.getText() != null) {
            targetPresentation.setText(sourcePresentation.getText());
        }
        if (targetPresentation.getDescription() == null && sourcePresentation.getDescription() != null) {
            targetPresentation.setDescription(sourcePresentation.getDescription());
        }
        targetAction.setShortcutSet(this.getShortcutSet());
    }

    public String getProjectType() {
        return this.myProjectType;
    }
}

