/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.NotificationGroup");
    private static final Map<String, NotificationGroup> ourRegisteredGroups = ContainerUtil.newConcurrentMap();
    @NotNull
    private final String myDisplayId;
    @NotNull
    private final NotificationDisplayType myDisplayType;
    private final boolean myLogByDefault;
    @Nullable
    private final String myToolWindowId;

    public NotificationGroup(@NotNull String displayId, @NotNull NotificationDisplayType defaultDisplayType, boolean logByDefault) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayId", "com/intellij/notification/NotificationGroup", "<init>"));
        }
        if (defaultDisplayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultDisplayType", "com/intellij/notification/NotificationGroup", "<init>"));
        }
        this(displayId, defaultDisplayType, logByDefault, null);
    }

    public NotificationGroup(@NotNull String displayId, @NotNull NotificationDisplayType defaultDisplayType, boolean logByDefault, @Nullable String toolWindowId) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayId", "com/intellij/notification/NotificationGroup", "<init>"));
        }
        if (defaultDisplayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultDisplayType", "com/intellij/notification/NotificationGroup", "<init>"));
        }
        this.myDisplayId = displayId;
        this.myDisplayType = defaultDisplayType;
        this.myLogByDefault = logByDefault;
        this.myToolWindowId = toolWindowId;
        if (ourRegisteredGroups.containsKey(displayId)) {
            LOG.info("Notification group " + displayId + " is already registered", new Throwable());
        }
        ourRegisteredGroups.put(displayId, this);
    }

    @NotNull
    public static NotificationGroup balloonGroup(@NotNull String displayId) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayId", "com/intellij/notification/NotificationGroup", "balloonGroup"));
        }
        NotificationGroup notificationGroup = new NotificationGroup(displayId, NotificationDisplayType.BALLOON, true);
        if (notificationGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/NotificationGroup", "balloonGroup"));
        }
        return notificationGroup;
    }

    @NotNull
    public static NotificationGroup logOnlyGroup(@NotNull String displayId) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayId", "com/intellij/notification/NotificationGroup", "logOnlyGroup"));
        }
        NotificationGroup notificationGroup = new NotificationGroup(displayId, NotificationDisplayType.NONE, true);
        if (notificationGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/NotificationGroup", "logOnlyGroup"));
        }
        return notificationGroup;
    }

    @NotNull
    public static NotificationGroup toolWindowGroup(@NotNull String displayId, @NotNull String toolWindowId, boolean logByDefault) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayId", "com/intellij/notification/NotificationGroup", "toolWindowGroup"));
        }
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/notification/NotificationGroup", "toolWindowGroup"));
        }
        NotificationGroup notificationGroup = new NotificationGroup(displayId, NotificationDisplayType.TOOL_WINDOW, logByDefault, toolWindowId);
        if (notificationGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/NotificationGroup", "toolWindowGroup"));
        }
        return notificationGroup;
    }

    @NotNull
    public static NotificationGroup toolWindowGroup(@NotNull String displayId, @NotNull String toolWindowId) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayId", "com/intellij/notification/NotificationGroup", "toolWindowGroup"));
        }
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/notification/NotificationGroup", "toolWindowGroup"));
        }
        NotificationGroup notificationGroup = NotificationGroup.toolWindowGroup(displayId, toolWindowId, true);
        if (notificationGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/NotificationGroup", "toolWindowGroup"));
        }
        return notificationGroup;
    }

    @NotNull
    public String getDisplayId() {
        String string = this.myDisplayId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/NotificationGroup", "getDisplayId"));
        }
        return string;
    }

    public Notification createNotification(@NotNull String content, @NotNull MessageType type) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        return this.createNotification(content, type.toNotificationType());
    }

    @NotNull
    public Notification createNotification(@NotNull String content, @NotNull NotificationType type) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        Notification notification = this.createNotification("", content, type, null);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        return notification;
    }

    @NotNull
    public Notification createNotification(@NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        Notification notification = new Notification(this.myDisplayId, title, content, type, listener);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        return notification;
    }

    @NotNull
    public NotificationDisplayType getDisplayType() {
        NotificationDisplayType notificationDisplayType = this.myDisplayType;
        if (notificationDisplayType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/NotificationGroup", "getDisplayType"));
        }
        return notificationDisplayType;
    }

    public boolean isLogByDefault() {
        return this.myLogByDefault;
    }

    @Nullable
    public String getToolWindowId() {
        return this.myToolWindowId;
    }

    @Nullable
    public static NotificationGroup findRegisteredGroup(String displayId) {
        return ourRegisteredGroups.get(displayId);
    }

    @NotNull
    public static Iterable<NotificationGroup> getAllRegisteredGroups() {
        Collection<NotificationGroup> collection = ourRegisteredGroups.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/NotificationGroup", "getAllRegisteredGroups"));
        }
        return collection;
    }
}

