/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class ListWrappingTableModel
extends AbstractTableModel {
    private final List<List<String>> list;
    private final List<String> columnNames;

    public ListWrappingTableModel(@NotNull List<List<String>> list, String ... columnNames) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInspection/ui/ListWrappingTableModel", "<init>"));
        }
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/codeInspection/ui/ListWrappingTableModel", "<init>"));
        }
        this.columnNames = new ArrayList<String>();
        this.list = list;
        ContainerUtil.addAll(this.columnNames, (Object[])columnNames);
    }

    public ListWrappingTableModel(@NotNull List<String> list, @NotNull String columnName) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInspection/ui/ListWrappingTableModel", "<init>"));
        }
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/codeInspection/ui/ListWrappingTableModel", "<init>"));
        }
        this.columnNames = new ArrayList<String>();
        this.list = new ArrayList<List<String>>();
        this.list.add(list);
        this.columnNames.add(columnName);
    }

    public void addRow(String ... values) {
        int i;
        if (this.list.size() < values.length) {
            throw new IllegalArgumentException("number of table columns: " + this.list.size() + " does not match number of argument " + "columns: " + values.length);
        }
        for (i = 0; i < values.length; ++i) {
            String value = values[i];
            this.list.get(i).add(value);
        }
        int max = this.list.size();
        while (i < max) {
            this.list.get(i).add("");
            ++i;
        }
        int index = this.list.get(0).size() - 1;
        this.fireTableRowsInserted(index, index);
    }

    public void addRow() {
        int columnCount = this.list.size();
        Object[] strings = new String[columnCount];
        Arrays.fill(strings, "");
        this.addRow((String[])strings);
    }

    public Class<String> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < this.columnNames.size()) {
            return this.columnNames.get(columnIndex);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        List<String> column0 = this.list.get(0);
        if (column0 == null) {
            return 0;
        }
        return column0.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.list.get(columnIndex).get(rowIndex);
    }

    public int indexOf(String value, int columnIndex) {
        return this.list.get(columnIndex).indexOf(value);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void removeRow(int rowIndex) {
        for (List<String> column : this.list) {
            column.remove(rowIndex);
        }
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        List<String> strings = this.list.get(columnIndex);
        if (rowIndex >= 0 && rowIndex < strings.size()) {
            strings.set(rowIndex, String.valueOf(value));
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

