/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.analysis;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.NonRecursiveVisitor;
import java.util.Comparator;
import java.util.PriorityQueue;

public class ShortestDistanceVisitor
extends NonRecursiveVisitor {
    private PriorityQueue<Instance> mPriorityQueue = new PriorityQueue<Instance>(1024, new Comparator<Instance>(){

        @Override
        public int compare(Instance o1, Instance o2) {
            return o1.getDistanceToGcRoot() - o2.getDistanceToGcRoot();
        }
    });
    private Instance mPreviousInstance = null;
    private int mVisitDistance = 0;

    @Override
    public void visitLater(Instance parent, @NonNull Instance child) {
        if (this.mVisitDistance < child.getDistanceToGcRoot() && (parent == null || !parent.getIsSoftReference() || child.getIsSoftReference())) {
            child.setDistanceToGcRoot(this.mVisitDistance);
            child.setNextInstanceToGcRoot(this.mPreviousInstance);
            this.mPriorityQueue.add(child);
        }
    }

    @Override
    public void doVisit(Iterable<? extends Instance> startNodes) {
        for (Instance instance : startNodes) {
            instance.accept(this);
        }
        while (!this.mPriorityQueue.isEmpty()) {
            Instance node = this.mPriorityQueue.poll();
            this.mVisitDistance = node.getDistanceToGcRoot() + 1;
            this.mPreviousInstance = node;
            node.accept(this);
        }
    }
}

