/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.io.File;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import lombok.ast.StringLiteral;

public class SdCardDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("SdCardPath", "Hardcoded reference to `/sdcard`", "Your code should not reference the `/sdcard` path directly; instead use `Environment.getExternalStorageDirectory().getPath()`.\n\nSimilarly, do not reference the `/data/data/` path directly; it can vary in multi-user scenarios. Instead, use `Context.getFilesDir().getPath()`.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(SdCardDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/topics/data/data-storage.html#filesExternal");

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(StringLiteral.class);
    }

    @Override
    public AstVisitor createJavaVisitor(@NonNull JavaContext context) {
        return new StringChecker(context);
    }

    private static class StringChecker
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public StringChecker(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitStringLiteral(StringLiteral node) {
            String s = node.astValue();
            if (s.isEmpty()) {
                return false;
            }
            char c = s.charAt(0);
            if (c != '/' && c != 'f') {
                return false;
            }
            if (s.startsWith("/sdcard") || s.startsWith("/mnt/sdcard/") || s.startsWith("/system/media/sdcard") || s.startsWith("file://sdcard/") || s.startsWith("file:///sdcard/")) {
                String message = "Do not hardcode \"/sdcard/\"; use `Environment.getExternalStorageDirectory().getPath()` instead";
                Location location = this.mContext.getLocation((Node)node);
                this.mContext.report(ISSUE, (Node)node, location, message);
            } else if (s.startsWith("/data/data/") || s.startsWith("/data/user/")) {
                String message = "Do not hardcode \"`/data/`\"; use `Context.getFilesDir().getPath()` instead";
                Location location = this.mContext.getLocation((Node)node);
                this.mContext.report(ISSUE, (Node)node, location, message);
            }
            return false;
        }
    }
}

