/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.reflectasm;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import com.esotericsoftware.reflectasm.FieldAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AccessClassLoader
extends ClassLoader {
    private static final ArrayList<AccessClassLoader> accessClassLoaders = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AccessClassLoader get(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        ArrayList<AccessClassLoader> arrayList = accessClassLoaders;
        synchronized (arrayList) {
            int n = accessClassLoaders.size();
            for (int i = 0; i < n; ++i) {
                AccessClassLoader accessClassLoader = accessClassLoaders.get(i);
                if (accessClassLoader.getParent() != classLoader) continue;
                return accessClassLoader;
            }
            AccessClassLoader accessClassLoader = new AccessClassLoader(classLoader);
            accessClassLoaders.add(accessClassLoader);
            return accessClassLoader;
        }
    }

    private AccessClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (string.equals(FieldAccess.class.getName())) {
            return FieldAccess.class;
        }
        if (string.equals(MethodAccess.class.getName())) {
            return MethodAccess.class;
        }
        if (string.equals(ConstructorAccess.class.getName())) {
            return ConstructorAccess.class;
        }
        return super.loadClass(string, bl);
    }

    Class<?> defineClass(String string, byte[] byArray) throws ClassFormatError {
        try {
            Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return (Class)method.invoke((Object)this.getParent(), string, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return this.defineClass(string, byArray, 0, byArray.length);
        }
    }
}

