/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.util.BiFunction;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseInstanceFactory<T, P>
implements InstanceFactory<T, P> {
    private final String displayName;
    private final Map<Class<?>, Registration<?>> factories = Maps.newIdentityHashMap();

    public BaseInstanceFactory(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public <S extends T> void register(Class<S> type, @Nullable ModelRuleDescriptor sourceRule, BiFunction<? extends S, ? super P, ? super MutableModelNode> factory) {
        Registration<S> registration = this.getRegistration(type);
        if (registration != null) {
            StringBuilder builder = new StringBuilder("Cannot register a factory for type ").append(type.getSimpleName()).append(" because a factory for this type was already registered");
            if (((Registration)registration).source != null) {
                builder.append(" by ");
                ((Registration)registration).source.describeTo(builder);
            }
            builder.append(".");
            throw new GradleException(builder.toString());
        }
        this.factories.put(type, new Registration<S>(sourceRule, factory));
    }

    private <S extends T> Registration<S> getRegistration(Class<S> type) {
        return (Registration)Cast.uncheckedCast(this.factories.get(type));
    }

    @Override
    public <S extends T> S create(Class<S> type, MutableModelNode modelNode, P payload) {
        Registration<S> registration = this.getRegistration(type);
        if (registration == null) {
            throw new IllegalArgumentException(String.format("Cannot create a %s because this type is not known to %s. Known types are: %s", type.getSimpleName(), this.displayName, this.getSupportedTypeNames()));
        }
        return (S)((Registration)registration).factory.apply(payload, (Object)modelNode);
    }

    @Override
    public String getSupportedTypeNames() {
        ArrayList names = Lists.newArrayList();
        for (Class<?> clazz : this.factories.keySet()) {
            names.add(clazz.getSimpleName());
        }
        Collections.sort(names);
        return names.isEmpty() ? "(None)" : Joiner.on((String)", ").join((Iterable)names);
    }

    public String toString() {
        return "[" + this.getSupportedTypeNames() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Registration<S extends T> {
        private final ModelRuleDescriptor source;
        private final BiFunction<? extends S, ? super P, ? super MutableModelNode> factory;

        public Registration(ModelRuleDescriptor source, BiFunction<? extends S, ? super P, ? super MutableModelNode> factory) {
            this.source = source;
            this.factory = factory;
        }
    }
}

