/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import kotlin.IndexedValue;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"S\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\r\u0001e\t\u0001\u0014AQ\u0013\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011b\u0001\u0005\u0005\u001b\u0005AJ!U\u0002\u0002\u0011\u0015)s\u0003c\u0003\u000e\u0003a1\u0011d\u0001E\u0007\u001b\u0005Ar!G\u0002\t\u00105\t\u0001\u0004C\r\u0004\u0011#i\u0011\u0001G\u0005\u001a\u0007!MQ\"\u0001\r\u000b3\rA)\"D\u0001\u0019\u0017\u0015bA!\u0001E\f\u001b\u0005AB\"G\u0002\t\u00165\t\u0001dC\r\u0004\u00113i\u0011\u0001G\u0007*\u000f\u0011\t\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!!Q\"\u0001M\u0005#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001bA\u0007\u00021\u000f\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver;", "", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "symbolUsageValidator", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "(Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;)V", "defineLocalVariablesFromMultiDeclaration", "", "writableScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "reportErrorsOn", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getExpectedTypeForComponent", "Lorg/jetbrains/kotlin/types/KotlinType;", "entry", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;"}, moduleName="kotlin-compiler")
public final class DestructuringDeclarationResolver {
    private final FakeCallResolver fakeCallResolver;
    private final DescriptorResolver descriptorResolver;
    private final TypeResolver typeResolver;
    private final SymbolUsageValidator symbolUsageValidator;

    public final void defineLocalVariablesFromMultiDeclaration(@NotNull LexicalWritableScope writableScope, @NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ReceiverValue receiver, @NotNull KtExpression reportErrorsOn, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(writableScope, "writableScope");
        Intrinsics.checkParameterIsNotNull(destructuringDeclaration, "destructuringDeclaration");
        Intrinsics.checkParameterIsNotNull(receiver, "receiver");
        Intrinsics.checkParameterIsNotNull(reportErrorsOn, "reportErrorsOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)destructuringDeclaration.getEntries())) {
            int componentIndex = indexedValue.component1();
            KtDestructuringDeclarationEntry entry = (KtDestructuringDeclarationEntry)indexedValue.component2();
            Name componentName = DataClassUtilsKt.createComponentName(componentIndex + 1);
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull(ktDestructuringDeclarationEntry, "entry");
            KotlinType expectedType = this.getExpectedTypeForComponent(context, ktDestructuringDeclarationEntry);
            ExpressionTypingContext expressionTypingContext = (ExpressionTypingContext)context.replaceExpectedType(expectedType);
            Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "context.replaceExpectedType(expectedType)");
            KtExpression ktExpression = entry;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "entry");
            OverloadResolutionResults<FunctionDescriptor> results = this.fakeCallResolver.resolveFakeCall(expressionTypingContext, receiver, componentName, ktExpression);
            KotlinType componentType = null;
            if (results.isSuccess()) {
                context.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
                FunctionDescriptor functionDescriptor = results.getResultingDescriptor();
                ResolvedCall resolvedCall = null;
                CallableDescriptor callableDescriptor = functionDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "functionDescriptor");
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
                PsiElement psiElement2 = entry;
                Intrinsics.checkExpressionValueIsNotNull(psiElement2, "entry");
                this.symbolUsageValidator.validateCall(resolvedCall, callableDescriptor, bindingTrace, psiElement2);
                componentType = functionDescriptor.getReturnType();
                if (componentType != null && !TypeUtils.noExpectedType(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(componentType, expectedType)) {
                    context.trace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)reportErrorsOn), componentName, componentType, expectedType));
                }
            } else if (results.isAmbiguity()) {
                context.trace.report(Errors.COMPONENT_FUNCTION_AMBIGUITY.on((KtExpression)((PsiElement)reportErrorsOn), componentName, results.getResultingCalls()));
            } else {
                context.trace.report(Errors.COMPONENT_FUNCTION_MISSING.on((KtExpression)((PsiElement)reportErrorsOn), componentName, receiver.getType()));
            }
            if (componentType == null) {
                componentType = ErrorUtils.createErrorType(componentName + "() return type");
            }
            LocalVariableDescriptor variableDescriptor = this.descriptorResolver.resolveLocalVariableDescriptorWithType(writableScope, entry, componentType, context.trace);
            ExpressionTypingUtils.checkVariableShadowing(writableScope, context.trace, variableDescriptor);
            VariableDescriptor variableDescriptor2 = variableDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptor2, "variableDescriptor");
            writableScope.addVariableDescriptor(variableDescriptor2);
        }
    }

    private final KotlinType getExpectedTypeForComponent(ExpressionTypingContext context, KtDestructuringDeclarationEntry entry) {
        KtTypeReference ktTypeReference = entry.getTypeReference();
        if (ktTypeReference == null) {
            KotlinType kotlinType = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.NO_EXPECTED_TYPE");
            return kotlinType;
        }
        KtTypeReference entryTypeRef = ktTypeReference;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        KtTypeReference ktTypeReference2 = entryTypeRef;
        Intrinsics.checkExpressionValueIsNotNull(ktTypeReference2, "entryTypeRef");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        return this.typeResolver.resolveType(lexicalScope, ktTypeReference2, bindingTrace, true);
    }

    public DestructuringDeclarationResolver(@NotNull FakeCallResolver fakeCallResolver, @NotNull DescriptorResolver descriptorResolver, @NotNull TypeResolver typeResolver, @NotNull SymbolUsageValidator symbolUsageValidator) {
        Intrinsics.checkParameterIsNotNull(fakeCallResolver, "fakeCallResolver");
        Intrinsics.checkParameterIsNotNull(descriptorResolver, "descriptorResolver");
        Intrinsics.checkParameterIsNotNull(typeResolver, "typeResolver");
        Intrinsics.checkParameterIsNotNull(symbolUsageValidator, "symbolUsageValidator");
        this.fakeCallResolver = fakeCallResolver;
        this.descriptorResolver = descriptorResolver;
        this.typeResolver = typeResolver;
        this.symbolUsageValidator = symbolUsageValidator;
    }
}

